// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * IpamPool association information.
 */
@Fluent
public final class PoolAssociationInner implements JsonSerializable<PoolAssociationInner> {
    /*
     * Resource id of the associated Azure resource.
     */
    private String resourceId;

    /*
     * IpamPool id for which the resource is associated to.
     */
    private String poolId;

    /*
     * The description property.
     */
    private String description;

    /*
     * List of assigned IP address prefixes in the IpamPool of the associated resource.
     */
    private List<String> addressPrefixes;

    /*
     * List of reserved IP address prefixes in the IpamPool of the associated resource.
     */
    private List<String> reservedPrefixes;

    /*
     * Total number of assigned IP addresses of the association.
     */
    private String totalNumberOfIpAddresses;

    /*
     * Total number of reserved IP addresses of the association.
     */
    private String numberOfReservedIpAddresses;

    /*
     * Creation time of the association.
     */
    private OffsetDateTime createdAt;

    /*
     * Expire time for IP addresses reserved.
     */
    private OffsetDateTime reservationExpiresAt;

    /**
     * Creates an instance of PoolAssociationInner class.
     */
    public PoolAssociationInner() {
    }

    /**
     * Get the resourceId property: Resource id of the associated Azure resource.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: Resource id of the associated Azure resource.
     * 
     * @param resourceId the resourceId value to set.
     * @return the PoolAssociationInner object itself.
     */
    public PoolAssociationInner withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the poolId property: IpamPool id for which the resource is associated to.
     * 
     * @return the poolId value.
     */
    public String poolId() {
        return this.poolId;
    }

    /**
     * Set the poolId property: IpamPool id for which the resource is associated to.
     * 
     * @param poolId the poolId value to set.
     * @return the PoolAssociationInner object itself.
     */
    public PoolAssociationInner withPoolId(String poolId) {
        this.poolId = poolId;
        return this;
    }

    /**
     * Get the description property: The description property.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     * 
     * @param description the description value to set.
     * @return the PoolAssociationInner object itself.
     */
    public PoolAssociationInner withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the addressPrefixes property: List of assigned IP address prefixes in the IpamPool of the associated
     * resource.
     * 
     * @return the addressPrefixes value.
     */
    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    /**
     * Get the reservedPrefixes property: List of reserved IP address prefixes in the IpamPool of the associated
     * resource.
     * 
     * @return the reservedPrefixes value.
     */
    public List<String> reservedPrefixes() {
        return this.reservedPrefixes;
    }

    /**
     * Get the totalNumberOfIpAddresses property: Total number of assigned IP addresses of the association.
     * 
     * @return the totalNumberOfIpAddresses value.
     */
    public String totalNumberOfIpAddresses() {
        return this.totalNumberOfIpAddresses;
    }

    /**
     * Get the numberOfReservedIpAddresses property: Total number of reserved IP addresses of the association.
     * 
     * @return the numberOfReservedIpAddresses value.
     */
    public String numberOfReservedIpAddresses() {
        return this.numberOfReservedIpAddresses;
    }

    /**
     * Get the createdAt property: Creation time of the association.
     * 
     * @return the createdAt value.
     */
    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    /**
     * Get the reservationExpiresAt property: Expire time for IP addresses reserved.
     * 
     * @return the reservationExpiresAt value.
     */
    public OffsetDateTime reservationExpiresAt() {
        return this.reservationExpiresAt;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceId() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property resourceId in model PoolAssociationInner"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PoolAssociationInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("poolId", this.poolId);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PoolAssociationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PoolAssociationInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PoolAssociationInner.
     */
    public static PoolAssociationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PoolAssociationInner deserializedPoolAssociationInner = new PoolAssociationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceId".equals(fieldName)) {
                    deserializedPoolAssociationInner.resourceId = reader.getString();
                } else if ("poolId".equals(fieldName)) {
                    deserializedPoolAssociationInner.poolId = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedPoolAssociationInner.description = reader.getString();
                } else if ("addressPrefixes".equals(fieldName)) {
                    List<String> addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedPoolAssociationInner.addressPrefixes = addressPrefixes;
                } else if ("reservedPrefixes".equals(fieldName)) {
                    List<String> reservedPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedPoolAssociationInner.reservedPrefixes = reservedPrefixes;
                } else if ("totalNumberOfIPAddresses".equals(fieldName)) {
                    deserializedPoolAssociationInner.totalNumberOfIpAddresses = reader.getString();
                } else if ("numberOfReservedIPAddresses".equals(fieldName)) {
                    deserializedPoolAssociationInner.numberOfReservedIpAddresses = reader.getString();
                } else if ("createdAt".equals(fieldName)) {
                    deserializedPoolAssociationInner.createdAt = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("reservationExpiresAt".equals(fieldName)) {
                    deserializedPoolAssociationInner.reservationExpiresAt = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPoolAssociationInner;
        });
    }
}
