// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The response for a Health API.
 */
@Fluent
public final class LoadBalancerHealthPerRuleInner implements JsonSerializable<LoadBalancerHealthPerRuleInner> {
    /*
     * Number of backend instances associated to the LB rule that are considered healthy.
     */
    private Integer up;

    /*
     * Number of backend instances associated to the LB rule that are considered unhealthy.
     */
    private Integer down;

    /*
     * Information about the health per rule of the backend addresses.
     */
    private List<LoadBalancerHealthPerRulePerBackendAddressInner> loadBalancerBackendAddresses;

    /**
     * Creates an instance of LoadBalancerHealthPerRuleInner class.
     */
    public LoadBalancerHealthPerRuleInner() {
    }

    /**
     * Get the up property: Number of backend instances associated to the LB rule that are considered healthy.
     * 
     * @return the up value.
     */
    public Integer up() {
        return this.up;
    }

    /**
     * Set the up property: Number of backend instances associated to the LB rule that are considered healthy.
     * 
     * @param up the up value to set.
     * @return the LoadBalancerHealthPerRuleInner object itself.
     */
    public LoadBalancerHealthPerRuleInner withUp(Integer up) {
        this.up = up;
        return this;
    }

    /**
     * Get the down property: Number of backend instances associated to the LB rule that are considered unhealthy.
     * 
     * @return the down value.
     */
    public Integer down() {
        return this.down;
    }

    /**
     * Set the down property: Number of backend instances associated to the LB rule that are considered unhealthy.
     * 
     * @param down the down value to set.
     * @return the LoadBalancerHealthPerRuleInner object itself.
     */
    public LoadBalancerHealthPerRuleInner withDown(Integer down) {
        this.down = down;
        return this;
    }

    /**
     * Get the loadBalancerBackendAddresses property: Information about the health per rule of the backend addresses.
     * 
     * @return the loadBalancerBackendAddresses value.
     */
    public List<LoadBalancerHealthPerRulePerBackendAddressInner> loadBalancerBackendAddresses() {
        return this.loadBalancerBackendAddresses;
    }

    /**
     * Set the loadBalancerBackendAddresses property: Information about the health per rule of the backend addresses.
     * 
     * @param loadBalancerBackendAddresses the loadBalancerBackendAddresses value to set.
     * @return the LoadBalancerHealthPerRuleInner object itself.
     */
    public LoadBalancerHealthPerRuleInner withLoadBalancerBackendAddresses(
        List<LoadBalancerHealthPerRulePerBackendAddressInner> loadBalancerBackendAddresses) {
        this.loadBalancerBackendAddresses = loadBalancerBackendAddresses;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (loadBalancerBackendAddresses() != null) {
            loadBalancerBackendAddresses().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("up", this.up);
        jsonWriter.writeNumberField("down", this.down);
        jsonWriter.writeArrayField("loadBalancerBackendAddresses", this.loadBalancerBackendAddresses,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LoadBalancerHealthPerRuleInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LoadBalancerHealthPerRuleInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LoadBalancerHealthPerRuleInner.
     */
    public static LoadBalancerHealthPerRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LoadBalancerHealthPerRuleInner deserializedLoadBalancerHealthPerRuleInner
                = new LoadBalancerHealthPerRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("up".equals(fieldName)) {
                    deserializedLoadBalancerHealthPerRuleInner.up = reader.getNullable(JsonReader::getInt);
                } else if ("down".equals(fieldName)) {
                    deserializedLoadBalancerHealthPerRuleInner.down = reader.getNullable(JsonReader::getInt);
                } else if ("loadBalancerBackendAddresses".equals(fieldName)) {
                    List<LoadBalancerHealthPerRulePerBackendAddressInner> loadBalancerBackendAddresses = reader
                        .readArray(reader1 -> LoadBalancerHealthPerRulePerBackendAddressInner.fromJson(reader1));
                    deserializedLoadBalancerHealthPerRuleInner.loadBalancerBackendAddresses
                        = loadBalancerBackendAddresses;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLoadBalancerHealthPerRuleInner;
        });
    }
}
