/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class SharedKeyProperties
implements JsonSerializable<SharedKeyProperties> {
    private String sharedKey;
    private Integer sharedKeyLength;
    private ProvisioningState provisioningState;

    public String sharedKey() {
        return this.sharedKey;
    }

    public SharedKeyProperties withSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
        return this;
    }

    public Integer sharedKeyLength() {
        return this.sharedKeyLength;
    }

    public SharedKeyProperties withSharedKeyLength(Integer sharedKeyLength) {
        this.sharedKeyLength = sharedKeyLength;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sharedKey", this.sharedKey);
        jsonWriter.writeNumberField("sharedKeyLength", (Number)this.sharedKeyLength);
        return jsonWriter.writeEndObject();
    }

    public static SharedKeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SharedKeyProperties)jsonReader.readObject(reader -> {
            SharedKeyProperties deserializedSharedKeyProperties = new SharedKeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sharedKey".equals(fieldName)) {
                    deserializedSharedKeyProperties.sharedKey = reader.getString();
                    continue;
                }
                if ("sharedKeyLength".equals(fieldName)) {
                    deserializedSharedKeyProperties.sharedKeyLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSharedKeyProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSharedKeyProperties;
        });
    }
}

