/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpamPoolUpdateProperties;
import java.io.IOException;
import java.util.Map;

public final class IpamPoolUpdate
implements JsonSerializable<IpamPoolUpdate> {
    private Map<String, String> tags;
    private IpamPoolUpdateProperties properties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public IpamPoolUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public IpamPoolUpdateProperties properties() {
        return this.properties;
    }

    public IpamPoolUpdate withProperties(IpamPoolUpdateProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static IpamPoolUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (IpamPoolUpdate)jsonReader.readObject(reader -> {
            IpamPoolUpdate deserializedIpamPoolUpdate = new IpamPoolUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedIpamPoolUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIpamPoolUpdate.properties = IpamPoolUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpamPoolUpdate;
        });
    }
}

