/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityRuleAccess;
import com.azure.resourcemanager.network.models.SecurityRuleDirection;
import com.azure.resourcemanager.network.models.SecurityRuleProtocol;
import java.io.IOException;
import java.util.List;

public final class SecurityRulePropertiesFormat
implements JsonSerializable<SecurityRulePropertiesFormat> {
    private String description;
    private SecurityRuleProtocol protocol;
    private String sourcePortRange;
    private String destinationPortRange;
    private String sourceAddressPrefix;
    private List<String> sourceAddressPrefixes;
    private List<ApplicationSecurityGroupInner> sourceApplicationSecurityGroups;
    private String destinationAddressPrefix;
    private List<String> destinationAddressPrefixes;
    private List<ApplicationSecurityGroupInner> destinationApplicationSecurityGroups;
    private List<String> sourcePortRanges;
    private List<String> destinationPortRanges;
    private SecurityRuleAccess access;
    private int priority;
    private SecurityRuleDirection direction;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(SecurityRulePropertiesFormat.class);

    public String description() {
        return this.description;
    }

    public SecurityRulePropertiesFormat withDescription(String description) {
        this.description = description;
        return this;
    }

    public SecurityRuleProtocol protocol() {
        return this.protocol;
    }

    public SecurityRulePropertiesFormat withProtocol(SecurityRuleProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public String sourcePortRange() {
        return this.sourcePortRange;
    }

    public SecurityRulePropertiesFormat withSourcePortRange(String sourcePortRange) {
        this.sourcePortRange = sourcePortRange;
        return this;
    }

    public String destinationPortRange() {
        return this.destinationPortRange;
    }

    public SecurityRulePropertiesFormat withDestinationPortRange(String destinationPortRange) {
        this.destinationPortRange = destinationPortRange;
        return this;
    }

    public String sourceAddressPrefix() {
        return this.sourceAddressPrefix;
    }

    public SecurityRulePropertiesFormat withSourceAddressPrefix(String sourceAddressPrefix) {
        this.sourceAddressPrefix = sourceAddressPrefix;
        return this;
    }

    public List<String> sourceAddressPrefixes() {
        return this.sourceAddressPrefixes;
    }

    public SecurityRulePropertiesFormat withSourceAddressPrefixes(List<String> sourceAddressPrefixes) {
        this.sourceAddressPrefixes = sourceAddressPrefixes;
        return this;
    }

    public List<ApplicationSecurityGroupInner> sourceApplicationSecurityGroups() {
        return this.sourceApplicationSecurityGroups;
    }

    public SecurityRulePropertiesFormat withSourceApplicationSecurityGroups(List<ApplicationSecurityGroupInner> sourceApplicationSecurityGroups) {
        this.sourceApplicationSecurityGroups = sourceApplicationSecurityGroups;
        return this;
    }

    public String destinationAddressPrefix() {
        return this.destinationAddressPrefix;
    }

    public SecurityRulePropertiesFormat withDestinationAddressPrefix(String destinationAddressPrefix) {
        this.destinationAddressPrefix = destinationAddressPrefix;
        return this;
    }

    public List<String> destinationAddressPrefixes() {
        return this.destinationAddressPrefixes;
    }

    public SecurityRulePropertiesFormat withDestinationAddressPrefixes(List<String> destinationAddressPrefixes) {
        this.destinationAddressPrefixes = destinationAddressPrefixes;
        return this;
    }

    public List<ApplicationSecurityGroupInner> destinationApplicationSecurityGroups() {
        return this.destinationApplicationSecurityGroups;
    }

    public SecurityRulePropertiesFormat withDestinationApplicationSecurityGroups(List<ApplicationSecurityGroupInner> destinationApplicationSecurityGroups) {
        this.destinationApplicationSecurityGroups = destinationApplicationSecurityGroups;
        return this;
    }

    public List<String> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public SecurityRulePropertiesFormat withSourcePortRanges(List<String> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    public List<String> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    public SecurityRulePropertiesFormat withDestinationPortRanges(List<String> destinationPortRanges) {
        this.destinationPortRanges = destinationPortRanges;
        return this;
    }

    public SecurityRuleAccess access() {
        return this.access;
    }

    public SecurityRulePropertiesFormat withAccess(SecurityRuleAccess access) {
        this.access = access;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public SecurityRulePropertiesFormat withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public SecurityRuleDirection direction() {
        return this.direction;
    }

    public SecurityRulePropertiesFormat withDirection(SecurityRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.protocol() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property protocol in model SecurityRulePropertiesFormat"));
        }
        if (this.sourceApplicationSecurityGroups() != null) {
            this.sourceApplicationSecurityGroups().forEach(e -> e.validate());
        }
        if (this.destinationApplicationSecurityGroups() != null) {
            this.destinationApplicationSecurityGroups().forEach(e -> e.validate());
        }
        if (this.access() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property access in model SecurityRulePropertiesFormat"));
        }
        if (this.direction() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property direction in model SecurityRulePropertiesFormat"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeStringField("access", this.access == null ? null : this.access.toString());
        jsonWriter.writeIntField("priority", this.priority);
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("sourcePortRange", this.sourcePortRange);
        jsonWriter.writeStringField("destinationPortRange", this.destinationPortRange);
        jsonWriter.writeStringField("sourceAddressPrefix", this.sourceAddressPrefix);
        jsonWriter.writeArrayField("sourceAddressPrefixes", this.sourceAddressPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("sourceApplicationSecurityGroups", this.sourceApplicationSecurityGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("destinationAddressPrefix", this.destinationAddressPrefix);
        jsonWriter.writeArrayField("destinationAddressPrefixes", this.destinationAddressPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationApplicationSecurityGroups", this.destinationApplicationSecurityGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("sourcePortRanges", this.sourcePortRanges, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationPortRanges", this.destinationPortRanges, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SecurityRulePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityRulePropertiesFormat)jsonReader.readObject(reader -> {
            SecurityRulePropertiesFormat deserializedSecurityRulePropertiesFormat = new SecurityRulePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("protocol".equals(fieldName)) {
                    deserializedSecurityRulePropertiesFormat.protocol = SecurityRuleProtocol.fromString(reader.getString());
                    continue;
                }
                if ("access".equals(fieldName)) {
                    deserializedSecurityRulePropertiesFormat.access = SecurityRuleAccess.fromString(reader.getString());
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedSecurityRulePropertiesFormat.priority = reader.getInt();
                    continue;
                }
                if ("direction".equals(fieldName)) {
                    deserializedSecurityRulePropertiesFormat.direction = SecurityRuleDirection.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSecurityRulePropertiesFormat.description = reader.getString();
                    continue;
                }
                if ("sourcePortRange".equals(fieldName)) {
                    deserializedSecurityRulePropertiesFormat.sourcePortRange = reader.getString();
                    continue;
                }
                if ("destinationPortRange".equals(fieldName)) {
                    deserializedSecurityRulePropertiesFormat.destinationPortRange = reader.getString();
                    continue;
                }
                if ("sourceAddressPrefix".equals(fieldName)) {
                    deserializedSecurityRulePropertiesFormat.sourceAddressPrefix = reader.getString();
                    continue;
                }
                if ("sourceAddressPrefixes".equals(fieldName)) {
                    List sourceAddressPrefixes;
                    deserializedSecurityRulePropertiesFormat.sourceAddressPrefixes = sourceAddressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("sourceApplicationSecurityGroups".equals(fieldName)) {
                    List sourceApplicationSecurityGroups;
                    deserializedSecurityRulePropertiesFormat.sourceApplicationSecurityGroups = sourceApplicationSecurityGroups = reader.readArray(reader1 -> ApplicationSecurityGroupInner.fromJson(reader1));
                    continue;
                }
                if ("destinationAddressPrefix".equals(fieldName)) {
                    deserializedSecurityRulePropertiesFormat.destinationAddressPrefix = reader.getString();
                    continue;
                }
                if ("destinationAddressPrefixes".equals(fieldName)) {
                    List destinationAddressPrefixes;
                    deserializedSecurityRulePropertiesFormat.destinationAddressPrefixes = destinationAddressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("destinationApplicationSecurityGroups".equals(fieldName)) {
                    List destinationApplicationSecurityGroups;
                    deserializedSecurityRulePropertiesFormat.destinationApplicationSecurityGroups = destinationApplicationSecurityGroups = reader.readArray(reader1 -> ApplicationSecurityGroupInner.fromJson(reader1));
                    continue;
                }
                if ("sourcePortRanges".equals(fieldName)) {
                    List sourcePortRanges;
                    deserializedSecurityRulePropertiesFormat.sourcePortRanges = sourcePortRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("destinationPortRanges".equals(fieldName)) {
                    List destinationPortRanges;
                    deserializedSecurityRulePropertiesFormat.destinationPortRanges = destinationPortRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSecurityRulePropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityRulePropertiesFormat;
        });
    }
}

