/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.RouteInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class RouteTablePropertiesFormat
implements JsonSerializable<RouteTablePropertiesFormat> {
    private List<RouteInner> routes;
    private List<SubnetInner> subnets;
    private Boolean disableBgpRoutePropagation;
    private ProvisioningState provisioningState;
    private String resourceGuid;

    public List<RouteInner> routes() {
        return this.routes;
    }

    public RouteTablePropertiesFormat withRoutes(List<RouteInner> routes) {
        this.routes = routes;
        return this;
    }

    public List<SubnetInner> subnets() {
        return this.subnets;
    }

    public Boolean disableBgpRoutePropagation() {
        return this.disableBgpRoutePropagation;
    }

    public RouteTablePropertiesFormat withDisableBgpRoutePropagation(Boolean disableBgpRoutePropagation) {
        this.disableBgpRoutePropagation = disableBgpRoutePropagation;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.routes() != null) {
            this.routes().forEach(e -> e.validate());
        }
        if (this.subnets() != null) {
            this.subnets().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("routes", this.routes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("disableBgpRoutePropagation", this.disableBgpRoutePropagation);
        return jsonWriter.writeEndObject();
    }

    public static RouteTablePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (RouteTablePropertiesFormat)jsonReader.readObject(reader -> {
            RouteTablePropertiesFormat deserializedRouteTablePropertiesFormat = new RouteTablePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("routes".equals(fieldName)) {
                    List routes;
                    deserializedRouteTablePropertiesFormat.routes = routes = reader.readArray(reader1 -> RouteInner.fromJson(reader1));
                    continue;
                }
                if ("subnets".equals(fieldName)) {
                    List subnets;
                    deserializedRouteTablePropertiesFormat.subnets = subnets = reader.readArray(reader1 -> SubnetInner.fromJson(reader1));
                    continue;
                }
                if ("disableBgpRoutePropagation".equals(fieldName)) {
                    deserializedRouteTablePropertiesFormat.disableBgpRoutePropagation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRouteTablePropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedRouteTablePropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteTablePropertiesFormat;
        });
    }
}

