// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Stop packet capture parameters.
 */
@Fluent
public final class VpnPacketCaptureStopParameters implements JsonSerializable<VpnPacketCaptureStopParameters> {
    /*
     * SAS url for packet capture on virtual network gateway.
     */
    private String sasUrl;

    /**
     * Creates an instance of VpnPacketCaptureStopParameters class.
     */
    public VpnPacketCaptureStopParameters() {
    }

    /**
     * Get the sasUrl property: SAS url for packet capture on virtual network gateway.
     * 
     * @return the sasUrl value.
     */
    public String sasUrl() {
        return this.sasUrl;
    }

    /**
     * Set the sasUrl property: SAS url for packet capture on virtual network gateway.
     * 
     * @param sasUrl the sasUrl value to set.
     * @return the VpnPacketCaptureStopParameters object itself.
     */
    public VpnPacketCaptureStopParameters withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sasUrl", this.sasUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnPacketCaptureStopParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnPacketCaptureStopParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnPacketCaptureStopParameters.
     */
    public static VpnPacketCaptureStopParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnPacketCaptureStopParameters deserializedVpnPacketCaptureStopParameters
                = new VpnPacketCaptureStopParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sasUrl".equals(fieldName)) {
                    deserializedVpnPacketCaptureStopParameters.sasUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnPacketCaptureStopParameters;
        });
    }
}
