// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Vpn Client Connection configuration PolicyGroup member.
 */
@Fluent
public final class VirtualNetworkGatewayPolicyGroupMember
    implements JsonSerializable<VirtualNetworkGatewayPolicyGroupMember> {
    /*
     * Name of the VirtualNetworkGatewayPolicyGroupMember.
     */
    private String name;

    /*
     * The Vpn Policy member attribute type.
     */
    private VpnPolicyMemberAttributeType attributeType;

    /*
     * The value of Attribute used for this VirtualNetworkGatewayPolicyGroupMember.
     */
    private String attributeValue;

    /**
     * Creates an instance of VirtualNetworkGatewayPolicyGroupMember class.
     */
    public VirtualNetworkGatewayPolicyGroupMember() {
    }

    /**
     * Get the name property: Name of the VirtualNetworkGatewayPolicyGroupMember.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the VirtualNetworkGatewayPolicyGroupMember.
     * 
     * @param name the name value to set.
     * @return the VirtualNetworkGatewayPolicyGroupMember object itself.
     */
    public VirtualNetworkGatewayPolicyGroupMember withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the attributeType property: The Vpn Policy member attribute type.
     * 
     * @return the attributeType value.
     */
    public VpnPolicyMemberAttributeType attributeType() {
        return this.attributeType;
    }

    /**
     * Set the attributeType property: The Vpn Policy member attribute type.
     * 
     * @param attributeType the attributeType value to set.
     * @return the VirtualNetworkGatewayPolicyGroupMember object itself.
     */
    public VirtualNetworkGatewayPolicyGroupMember withAttributeType(VpnPolicyMemberAttributeType attributeType) {
        this.attributeType = attributeType;
        return this;
    }

    /**
     * Get the attributeValue property: The value of Attribute used for this VirtualNetworkGatewayPolicyGroupMember.
     * 
     * @return the attributeValue value.
     */
    public String attributeValue() {
        return this.attributeValue;
    }

    /**
     * Set the attributeValue property: The value of Attribute used for this VirtualNetworkGatewayPolicyGroupMember.
     * 
     * @param attributeValue the attributeValue value to set.
     * @return the VirtualNetworkGatewayPolicyGroupMember object itself.
     */
    public VirtualNetworkGatewayPolicyGroupMember withAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("attributeType", this.attributeType == null ? null : this.attributeType.toString());
        jsonWriter.writeStringField("attributeValue", this.attributeValue);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkGatewayPolicyGroupMember from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkGatewayPolicyGroupMember if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkGatewayPolicyGroupMember.
     */
    public static VirtualNetworkGatewayPolicyGroupMember fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkGatewayPolicyGroupMember deserializedVirtualNetworkGatewayPolicyGroupMember
                = new VirtualNetworkGatewayPolicyGroupMember();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPolicyGroupMember.name = reader.getString();
                } else if ("attributeType".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPolicyGroupMember.attributeType
                        = VpnPolicyMemberAttributeType.fromString(reader.getString());
                } else if ("attributeValue".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPolicyGroupMember.attributeValue = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkGatewayPolicyGroupMember;
        });
    }
}
