// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Virtual Hub identifier.
 */
@Fluent
public final class VirtualHubId implements JsonSerializable<VirtualHubId> {
    /*
     * The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub
     * resource and the ExpressRoute gateway resource reside in the same subscription.
     */
    private String id;

    /**
     * Creates an instance of VirtualHubId class.
     */
    public VirtualHubId() {
    }

    /**
     * Get the id property: The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed.
     * The Virtual Hub resource and the ExpressRoute gateway resource reside in the same subscription.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed.
     * The Virtual Hub resource and the ExpressRoute gateway resource reside in the same subscription.
     * 
     * @param id the id value to set.
     * @return the VirtualHubId object itself.
     */
    public VirtualHubId withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualHubId from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualHubId if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualHubId.
     */
    public static VirtualHubId fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualHubId deserializedVirtualHubId = new VirtualHubId();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedVirtualHubId.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualHubId;
        });
    }
}
