// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Routing rule next hop type.
 */
public final class RoutingRuleNextHopType extends ExpandableStringEnum<RoutingRuleNextHopType> {
    /**
     * Static value Internet for RoutingRuleNextHopType.
     */
    public static final RoutingRuleNextHopType INTERNET = fromString("Internet");

    /**
     * Static value NoNextHop for RoutingRuleNextHopType.
     */
    public static final RoutingRuleNextHopType NO_NEXT_HOP = fromString("NoNextHop");

    /**
     * Static value VirtualAppliance for RoutingRuleNextHopType.
     */
    public static final RoutingRuleNextHopType VIRTUAL_APPLIANCE = fromString("VirtualAppliance");

    /**
     * Static value VirtualNetworkGateway for RoutingRuleNextHopType.
     */
    public static final RoutingRuleNextHopType VIRTUAL_NETWORK_GATEWAY = fromString("VirtualNetworkGateway");

    /**
     * Static value VnetLocal for RoutingRuleNextHopType.
     */
    public static final RoutingRuleNextHopType VNET_LOCAL = fromString("VnetLocal");

    /**
     * Creates a new instance of RoutingRuleNextHopType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public RoutingRuleNextHopType() {
    }

    /**
     * Creates or finds a RoutingRuleNextHopType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding RoutingRuleNextHopType.
     */
    public static RoutingRuleNextHopType fromString(String name) {
        return fromString(name, RoutingRuleNextHopType.class);
    }

    /**
     * Gets known RoutingRuleNextHopType values.
     * 
     * @return known RoutingRuleNextHopType values.
     */
    public static Collection<RoutingRuleNextHopType> values() {
        return values(RoutingRuleNextHopType.class);
    }
}
