// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * SKU of a load balancer.
 */
@Fluent
public final class LoadBalancerSku implements JsonSerializable<LoadBalancerSku> {
    /*
     * Name of a load balancer SKU.
     */
    private LoadBalancerSkuName name;

    /*
     * Tier of a load balancer SKU.
     */
    private LoadBalancerSkuTier tier;

    /**
     * Creates an instance of LoadBalancerSku class.
     */
    public LoadBalancerSku() {
    }

    /**
     * Get the name property: Name of a load balancer SKU.
     * 
     * @return the name value.
     */
    public LoadBalancerSkuName name() {
        return this.name;
    }

    /**
     * Set the name property: Name of a load balancer SKU.
     * 
     * @param name the name value to set.
     * @return the LoadBalancerSku object itself.
     */
    public LoadBalancerSku withName(LoadBalancerSkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the tier property: Tier of a load balancer SKU.
     * 
     * @return the tier value.
     */
    public LoadBalancerSkuTier tier() {
        return this.tier;
    }

    /**
     * Set the tier property: Tier of a load balancer SKU.
     * 
     * @param tier the tier value to set.
     * @return the LoadBalancerSku object itself.
     */
    public LoadBalancerSku withTier(LoadBalancerSkuTier tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LoadBalancerSku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LoadBalancerSku if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LoadBalancerSku.
     */
    public static LoadBalancerSku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LoadBalancerSku deserializedLoadBalancerSku = new LoadBalancerSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedLoadBalancerSku.name = LoadBalancerSkuName.fromString(reader.getString());
                } else if ("tier".equals(fieldName)) {
                    deserializedLoadBalancerSku.tier = LoadBalancerSkuTier.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLoadBalancerSku;
        });
    }
}
