// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Information about an issue encountered in the process of checking for connectivity.
 */
@Immutable
public final class ConnectivityIssue implements JsonSerializable<ConnectivityIssue> {
    /*
     * The origin of the issue.
     */
    private Origin origin;

    /*
     * The severity of the issue.
     */
    private Severity severity;

    /*
     * The type of issue.
     */
    private IssueType type;

    /*
     * Provides additional context on the issue.
     */
    private List<Map<String, String>> context;

    /**
     * Creates an instance of ConnectivityIssue class.
     */
    public ConnectivityIssue() {
    }

    /**
     * Get the origin property: The origin of the issue.
     * 
     * @return the origin value.
     */
    public Origin origin() {
        return this.origin;
    }

    /**
     * Get the severity property: The severity of the issue.
     * 
     * @return the severity value.
     */
    public Severity severity() {
        return this.severity;
    }

    /**
     * Get the type property: The type of issue.
     * 
     * @return the type value.
     */
    public IssueType type() {
        return this.type;
    }

    /**
     * Get the context property: Provides additional context on the issue.
     * 
     * @return the context value.
     */
    public List<Map<String, String>> context() {
        return this.context;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectivityIssue from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectivityIssue if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectivityIssue.
     */
    public static ConnectivityIssue fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectivityIssue deserializedConnectivityIssue = new ConnectivityIssue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("origin".equals(fieldName)) {
                    deserializedConnectivityIssue.origin = Origin.fromString(reader.getString());
                } else if ("severity".equals(fieldName)) {
                    deserializedConnectivityIssue.severity = Severity.fromString(reader.getString());
                } else if ("type".equals(fieldName)) {
                    deserializedConnectivityIssue.type = IssueType.fromString(reader.getString());
                } else if ("context".equals(fieldName)) {
                    List<Map<String, String>> context
                        = reader.readArray(reader1 -> reader1.readMap(reader2 -> reader2.getString()));
                    deserializedConnectivityIssue.context = context;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectivityIssue;
        });
    }
}
