// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ConnectivityConfigurationInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list network manager connectivity configurations. It contains a list of configurations and a
 * link to get the next set of results.
 */
@Fluent
public final class ConnectivityConfigurationListResult
    implements JsonSerializable<ConnectivityConfigurationListResult> {
    /*
     * Gets a page of Connectivity Configurations
     */
    private List<ConnectivityConfigurationInner> value;

    /*
     * Gets the URL to get the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ConnectivityConfigurationListResult class.
     */
    public ConnectivityConfigurationListResult() {
    }

    /**
     * Get the value property: Gets a page of Connectivity Configurations.
     * 
     * @return the value value.
     */
    public List<ConnectivityConfigurationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets a page of Connectivity Configurations.
     * 
     * @param value the value value to set.
     * @return the ConnectivityConfigurationListResult object itself.
     */
    public ConnectivityConfigurationListResult withValue(List<ConnectivityConfigurationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next page of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ConnectivityConfigurationListResult object itself.
     */
    public ConnectivityConfigurationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectivityConfigurationListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectivityConfigurationListResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectivityConfigurationListResult.
     */
    public static ConnectivityConfigurationListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectivityConfigurationListResult deserializedConnectivityConfigurationListResult
                = new ConnectivityConfigurationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ConnectivityConfigurationInner> value
                        = reader.readArray(reader1 -> ConnectivityConfigurationInner.fromJson(reader1));
                    deserializedConnectivityConfigurationListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedConnectivityConfigurationListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectivityConfigurationListResult;
        });
    }
}
