// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of a service delegation.
 */
@Fluent
public final class ServiceDelegationPropertiesFormat implements JsonSerializable<ServiceDelegationPropertiesFormat> {
    /*
     * The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers).
     */
    private String serviceName;

    /*
     * The actions permitted to the service upon delegation.
     */
    private List<String> actions;

    /*
     * The provisioning state of the service delegation resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ServiceDelegationPropertiesFormat class.
     */
    public ServiceDelegationPropertiesFormat() {
    }

    /**
     * Get the serviceName property: The name of the service to whom the subnet should be delegated (e.g.
     * Microsoft.Sql/servers).
     * 
     * @return the serviceName value.
     */
    public String serviceName() {
        return this.serviceName;
    }

    /**
     * Set the serviceName property: The name of the service to whom the subnet should be delegated (e.g.
     * Microsoft.Sql/servers).
     * 
     * @param serviceName the serviceName value to set.
     * @return the ServiceDelegationPropertiesFormat object itself.
     */
    public ServiceDelegationPropertiesFormat withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    /**
     * Get the actions property: The actions permitted to the service upon delegation.
     * 
     * @return the actions value.
     */
    public List<String> actions() {
        return this.actions;
    }

    /**
     * Get the provisioningState property: The provisioning state of the service delegation resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceName", this.serviceName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceDelegationPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceDelegationPropertiesFormat if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServiceDelegationPropertiesFormat.
     */
    public static ServiceDelegationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceDelegationPropertiesFormat deserializedServiceDelegationPropertiesFormat
                = new ServiceDelegationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serviceName".equals(fieldName)) {
                    deserializedServiceDelegationPropertiesFormat.serviceName = reader.getString();
                } else if ("actions".equals(fieldName)) {
                    List<String> actions = reader.readArray(reader1 -> reader1.getString());
                    deserializedServiceDelegationPropertiesFormat.actions = actions;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedServiceDelegationPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServiceDelegationPropertiesFormat;
        });
    }
}
