// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AddressPrefixItem;
import com.azure.resourcemanager.network.models.ChildResource;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleDirection;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleProtocol;
import java.io.IOException;
import java.util.List;

/**
 * Network security user rule.
 */
@Fluent
public final class SecurityUserRuleInner extends ChildResource {
    /*
     * Indicates the properties of the security user rule
     */
    private SecurityUserRulePropertiesFormat innerProperties;

    /*
     * The system metadata related to this resource.
     */
    private SystemData systemData;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of SecurityUserRuleInner class.
     */
    public SecurityUserRuleInner() {
    }

    /**
     * Get the innerProperties property: Indicates the properties of the security user rule.
     * 
     * @return the innerProperties value.
     */
    private SecurityUserRulePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata related to this resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    @Override
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the description property: A description for this rule.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: A description for this rule.
     * 
     * @param description the description value to set.
     * @return the SecurityUserRuleInner object itself.
     */
    public SecurityUserRuleInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityUserRulePropertiesFormat();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the protocol property: Network protocol this rule applies to.
     * 
     * @return the protocol value.
     */
    public SecurityConfigurationRuleProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    /**
     * Set the protocol property: Network protocol this rule applies to.
     * 
     * @param protocol the protocol value to set.
     * @return the SecurityUserRuleInner object itself.
     */
    public SecurityUserRuleInner withProtocol(SecurityConfigurationRuleProtocol protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityUserRulePropertiesFormat();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    /**
     * Get the sources property: The CIDR or source IP ranges.
     * 
     * @return the sources value.
     */
    public List<AddressPrefixItem> sources() {
        return this.innerProperties() == null ? null : this.innerProperties().sources();
    }

    /**
     * Set the sources property: The CIDR or source IP ranges.
     * 
     * @param sources the sources value to set.
     * @return the SecurityUserRuleInner object itself.
     */
    public SecurityUserRuleInner withSources(List<AddressPrefixItem> sources) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityUserRulePropertiesFormat();
        }
        this.innerProperties().withSources(sources);
        return this;
    }

    /**
     * Get the destinations property: The destination address prefixes. CIDR or destination IP ranges.
     * 
     * @return the destinations value.
     */
    public List<AddressPrefixItem> destinations() {
        return this.innerProperties() == null ? null : this.innerProperties().destinations();
    }

    /**
     * Set the destinations property: The destination address prefixes. CIDR or destination IP ranges.
     * 
     * @param destinations the destinations value to set.
     * @return the SecurityUserRuleInner object itself.
     */
    public SecurityUserRuleInner withDestinations(List<AddressPrefixItem> destinations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityUserRulePropertiesFormat();
        }
        this.innerProperties().withDestinations(destinations);
        return this;
    }

    /**
     * Get the sourcePortRanges property: The source port ranges.
     * 
     * @return the sourcePortRanges value.
     */
    public List<String> sourcePortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().sourcePortRanges();
    }

    /**
     * Set the sourcePortRanges property: The source port ranges.
     * 
     * @param sourcePortRanges the sourcePortRanges value to set.
     * @return the SecurityUserRuleInner object itself.
     */
    public SecurityUserRuleInner withSourcePortRanges(List<String> sourcePortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityUserRulePropertiesFormat();
        }
        this.innerProperties().withSourcePortRanges(sourcePortRanges);
        return this;
    }

    /**
     * Get the destinationPortRanges property: The destination port ranges.
     * 
     * @return the destinationPortRanges value.
     */
    public List<String> destinationPortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationPortRanges();
    }

    /**
     * Set the destinationPortRanges property: The destination port ranges.
     * 
     * @param destinationPortRanges the destinationPortRanges value to set.
     * @return the SecurityUserRuleInner object itself.
     */
    public SecurityUserRuleInner withDestinationPortRanges(List<String> destinationPortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityUserRulePropertiesFormat();
        }
        this.innerProperties().withDestinationPortRanges(destinationPortRanges);
        return this;
    }

    /**
     * Get the direction property: Indicates if the traffic matched against the rule in inbound or outbound.
     * 
     * @return the direction value.
     */
    public SecurityConfigurationRuleDirection direction() {
        return this.innerProperties() == null ? null : this.innerProperties().direction();
    }

    /**
     * Set the direction property: Indicates if the traffic matched against the rule in inbound or outbound.
     * 
     * @param direction the direction value to set.
     * @return the SecurityUserRuleInner object itself.
     */
    public SecurityUserRuleInner withDirection(SecurityConfigurationRuleDirection direction) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityUserRulePropertiesFormat();
        }
        this.innerProperties().withDirection(direction);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the security configuration user rule resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the resourceGuid property: Unique identifier for this resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityUserRuleInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityUserRuleInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SecurityUserRuleInner.
     */
    public static SecurityUserRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityUserRuleInner deserializedSecurityUserRuleInner = new SecurityUserRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSecurityUserRuleInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSecurityUserRuleInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSecurityUserRuleInner.type = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedSecurityUserRuleInner.etag = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedSecurityUserRuleInner.innerProperties
                        = SecurityUserRulePropertiesFormat.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedSecurityUserRuleInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityUserRuleInner;
        });
    }
}
