// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.models.NetworkVirtualApplianceInner;
import com.azure.resourcemanager.network.fluent.models.NetworkVirtualApplianceInstanceIdsInner;
import com.azure.resourcemanager.network.models.TagsObject;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in NetworkVirtualAppliancesClient.
 */
public interface NetworkVirtualAppliancesClient extends InnerSupportsGet<NetworkVirtualApplianceInner>,
    InnerSupportsListing<NetworkVirtualApplianceInner>, InnerSupportsDelete<Void> {
    /**
     * Deletes the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String networkVirtualApplianceName);

    /**
     * Deletes the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkVirtualApplianceName);

    /**
     * Deletes the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkVirtualApplianceName);

    /**
     * Deletes the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkVirtualApplianceName,
        Context context);

    /**
     * Deletes the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String networkVirtualApplianceName);

    /**
     * Deletes the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkVirtualApplianceName);

    /**
     * Deletes the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkVirtualApplianceName, Context context);

    /**
     * Gets the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param expand Expands referenced resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified Network Virtual Appliance along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NetworkVirtualApplianceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String networkVirtualApplianceName, String expand);

    /**
     * Gets the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified Network Virtual Appliance on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkVirtualApplianceInner> getByResourceGroupAsync(String resourceGroupName,
        String networkVirtualApplianceName);

    /**
     * Gets the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param expand Expands referenced resources.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified Network Virtual Appliance along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NetworkVirtualApplianceInner> getByResourceGroupWithResponse(String resourceGroupName,
        String networkVirtualApplianceName, String expand, Context context);

    /**
     * Gets the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified Network Virtual Appliance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkVirtualApplianceInner getByResourceGroup(String resourceGroupName, String networkVirtualApplianceName);

    /**
     * Updates a Network Virtual Appliance.
     * 
     * @param resourceGroupName The resource group name of Network Virtual Appliance.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance being updated.
     * @param parameters Parameters supplied to Update Network Virtual Appliance Tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return networkVirtualAppliance Resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NetworkVirtualApplianceInner>> updateTagsWithResponseAsync(String resourceGroupName,
        String networkVirtualApplianceName, TagsObject parameters);

    /**
     * Updates a Network Virtual Appliance.
     * 
     * @param resourceGroupName The resource group name of Network Virtual Appliance.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance being updated.
     * @param parameters Parameters supplied to Update Network Virtual Appliance Tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return networkVirtualAppliance Resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkVirtualApplianceInner> updateTagsAsync(String resourceGroupName, String networkVirtualApplianceName,
        TagsObject parameters);

    /**
     * Updates a Network Virtual Appliance.
     * 
     * @param resourceGroupName The resource group name of Network Virtual Appliance.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance being updated.
     * @param parameters Parameters supplied to Update Network Virtual Appliance Tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return networkVirtualAppliance Resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NetworkVirtualApplianceInner> updateTagsWithResponse(String resourceGroupName,
        String networkVirtualApplianceName, TagsObject parameters, Context context);

    /**
     * Updates a Network Virtual Appliance.
     * 
     * @param resourceGroupName The resource group name of Network Virtual Appliance.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance being updated.
     * @param parameters Parameters supplied to Update Network Virtual Appliance Tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return networkVirtualAppliance Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkVirtualApplianceInner updateTags(String resourceGroupName, String networkVirtualApplianceName,
        TagsObject parameters);

    /**
     * Creates or updates the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param parameters Parameters supplied to the create or update Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return networkVirtualAppliance Resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String networkVirtualApplianceName, NetworkVirtualApplianceInner parameters);

    /**
     * Creates or updates the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param parameters Parameters supplied to the create or update Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of networkVirtualAppliance Resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<NetworkVirtualApplianceInner>, NetworkVirtualApplianceInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String networkVirtualApplianceName, NetworkVirtualApplianceInner parameters);

    /**
     * Creates or updates the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param parameters Parameters supplied to the create or update Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of networkVirtualAppliance Resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<NetworkVirtualApplianceInner>, NetworkVirtualApplianceInner> beginCreateOrUpdate(
        String resourceGroupName, String networkVirtualApplianceName, NetworkVirtualApplianceInner parameters);

    /**
     * Creates or updates the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param parameters Parameters supplied to the create or update Network Virtual Appliance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of networkVirtualAppliance Resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<NetworkVirtualApplianceInner>, NetworkVirtualApplianceInner> beginCreateOrUpdate(
        String resourceGroupName, String networkVirtualApplianceName, NetworkVirtualApplianceInner parameters,
        Context context);

    /**
     * Creates or updates the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param parameters Parameters supplied to the create or update Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return networkVirtualAppliance Resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkVirtualApplianceInner> createOrUpdateAsync(String resourceGroupName, String networkVirtualApplianceName,
        NetworkVirtualApplianceInner parameters);

    /**
     * Creates or updates the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param parameters Parameters supplied to the create or update Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return networkVirtualAppliance Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkVirtualApplianceInner createOrUpdate(String resourceGroupName, String networkVirtualApplianceName,
        NetworkVirtualApplianceInner parameters);

    /**
     * Creates or updates the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param parameters Parameters supplied to the create or update Network Virtual Appliance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return networkVirtualAppliance Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkVirtualApplianceInner createOrUpdate(String resourceGroupName, String networkVirtualApplianceName,
        NetworkVirtualApplianceInner parameters, Context context);

    /**
     * Restarts one or more VMs belonging to the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param networkVirtualApplianceInstanceIds Specifies a list of virtual machine instance IDs from the Network
     * Virtual Appliance VM instances.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies a list of virtual machine instance IDs from the Network Virtual Appliance VM instances along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName,
        String networkVirtualApplianceName, NetworkVirtualApplianceInstanceIdsInner networkVirtualApplianceInstanceIds);

    /**
     * Restarts one or more VMs belonging to the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param networkVirtualApplianceInstanceIds Specifies a list of virtual machine instance IDs from the Network
     * Virtual Appliance VM instances.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies a list of virtual machine instance IDs from the Network
     * Virtual Appliance VM instances.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<NetworkVirtualApplianceInstanceIdsInner>, NetworkVirtualApplianceInstanceIdsInner>
        beginRestartAsync(String resourceGroupName, String networkVirtualApplianceName,
            NetworkVirtualApplianceInstanceIdsInner networkVirtualApplianceInstanceIds);

    /**
     * Restarts one or more VMs belonging to the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies a list of virtual machine instance IDs from the Network
     * Virtual Appliance VM instances.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<NetworkVirtualApplianceInstanceIdsInner>, NetworkVirtualApplianceInstanceIdsInner>
        beginRestartAsync(String resourceGroupName, String networkVirtualApplianceName);

    /**
     * Restarts one or more VMs belonging to the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies a list of virtual machine instance IDs from the Network
     * Virtual Appliance VM instances.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<NetworkVirtualApplianceInstanceIdsInner>, NetworkVirtualApplianceInstanceIdsInner>
        beginRestart(String resourceGroupName, String networkVirtualApplianceName);

    /**
     * Restarts one or more VMs belonging to the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param networkVirtualApplianceInstanceIds Specifies a list of virtual machine instance IDs from the Network
     * Virtual Appliance VM instances.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies a list of virtual machine instance IDs from the Network
     * Virtual Appliance VM instances.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<NetworkVirtualApplianceInstanceIdsInner>, NetworkVirtualApplianceInstanceIdsInner>
        beginRestart(String resourceGroupName, String networkVirtualApplianceName,
            NetworkVirtualApplianceInstanceIdsInner networkVirtualApplianceInstanceIds, Context context);

    /**
     * Restarts one or more VMs belonging to the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param networkVirtualApplianceInstanceIds Specifies a list of virtual machine instance IDs from the Network
     * Virtual Appliance VM instances.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies a list of virtual machine instance IDs from the Network Virtual Appliance VM instances on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkVirtualApplianceInstanceIdsInner> restartAsync(String resourceGroupName,
        String networkVirtualApplianceName, NetworkVirtualApplianceInstanceIdsInner networkVirtualApplianceInstanceIds);

    /**
     * Restarts one or more VMs belonging to the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies a list of virtual machine instance IDs from the Network Virtual Appliance VM instances on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkVirtualApplianceInstanceIdsInner> restartAsync(String resourceGroupName,
        String networkVirtualApplianceName);

    /**
     * Restarts one or more VMs belonging to the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies a list of virtual machine instance IDs from the Network Virtual Appliance VM instances.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkVirtualApplianceInstanceIdsInner restart(String resourceGroupName, String networkVirtualApplianceName);

    /**
     * Restarts one or more VMs belonging to the specified Network Virtual Appliance.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkVirtualApplianceName The name of Network Virtual Appliance.
     * @param networkVirtualApplianceInstanceIds Specifies a list of virtual machine instance IDs from the Network
     * Virtual Appliance VM instances.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies a list of virtual machine instance IDs from the Network Virtual Appliance VM instances.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkVirtualApplianceInstanceIdsInner restart(String resourceGroupName, String networkVirtualApplianceName,
        NetworkVirtualApplianceInstanceIdsInner networkVirtualApplianceInstanceIds, Context context);

    /**
     * Lists all Network Virtual Appliances in a resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListNetworkVirtualAppliances API service call as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NetworkVirtualApplianceInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Lists all Network Virtual Appliances in a resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListNetworkVirtualAppliances API service call as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkVirtualApplianceInner> listByResourceGroup(String resourceGroupName);

    /**
     * Lists all Network Virtual Appliances in a resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListNetworkVirtualAppliances API service call as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkVirtualApplianceInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Gets all Network Virtual Appliances in a subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all Network Virtual Appliances in a subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NetworkVirtualApplianceInner> listAsync();

    /**
     * Gets all Network Virtual Appliances in a subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all Network Virtual Appliances in a subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkVirtualApplianceInner> list();

    /**
     * Gets all Network Virtual Appliances in a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all Network Virtual Appliances in a subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkVirtualApplianceInner> list(Context context);
}
