/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AddressPrefixItem;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleAccess;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleDirection;
import com.azure.resourcemanager.network.models.SecurityConfigurationRuleProtocol;
import java.io.IOException;
import java.util.List;

public final class AdminPropertiesFormat
implements JsonSerializable<AdminPropertiesFormat> {
    private String description;
    private SecurityConfigurationRuleProtocol protocol;
    private List<AddressPrefixItem> sources;
    private List<AddressPrefixItem> destinations;
    private List<String> sourcePortRanges;
    private List<String> destinationPortRanges;
    private SecurityConfigurationRuleAccess access;
    private int priority;
    private SecurityConfigurationRuleDirection direction;
    private ProvisioningState provisioningState;
    private String resourceGuid;
    private static final ClientLogger LOGGER = new ClientLogger(AdminPropertiesFormat.class);

    public String description() {
        return this.description;
    }

    public AdminPropertiesFormat withDescription(String description) {
        this.description = description;
        return this;
    }

    public SecurityConfigurationRuleProtocol protocol() {
        return this.protocol;
    }

    public AdminPropertiesFormat withProtocol(SecurityConfigurationRuleProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public List<AddressPrefixItem> sources() {
        return this.sources;
    }

    public AdminPropertiesFormat withSources(List<AddressPrefixItem> sources) {
        this.sources = sources;
        return this;
    }

    public List<AddressPrefixItem> destinations() {
        return this.destinations;
    }

    public AdminPropertiesFormat withDestinations(List<AddressPrefixItem> destinations) {
        this.destinations = destinations;
        return this;
    }

    public List<String> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public AdminPropertiesFormat withSourcePortRanges(List<String> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    public List<String> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    public AdminPropertiesFormat withDestinationPortRanges(List<String> destinationPortRanges) {
        this.destinationPortRanges = destinationPortRanges;
        return this;
    }

    public SecurityConfigurationRuleAccess access() {
        return this.access;
    }

    public AdminPropertiesFormat withAccess(SecurityConfigurationRuleAccess access) {
        this.access = access;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public AdminPropertiesFormat withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public SecurityConfigurationRuleDirection direction() {
        return this.direction;
    }

    public AdminPropertiesFormat withDirection(SecurityConfigurationRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.protocol() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property protocol in model AdminPropertiesFormat"));
        }
        if (this.sources() != null) {
            this.sources().forEach(e -> e.validate());
        }
        if (this.destinations() != null) {
            this.destinations().forEach(e -> e.validate());
        }
        if (this.access() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property access in model AdminPropertiesFormat"));
        }
        if (this.direction() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property direction in model AdminPropertiesFormat"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeStringField("access", this.access == null ? null : this.access.toString());
        jsonWriter.writeIntField("priority", this.priority);
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("sources", this.sources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("destinations", this.destinations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("sourcePortRanges", this.sourcePortRanges, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationPortRanges", this.destinationPortRanges, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AdminPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (AdminPropertiesFormat)jsonReader.readObject(reader -> {
            AdminPropertiesFormat deserializedAdminPropertiesFormat = new AdminPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("protocol".equals(fieldName)) {
                    deserializedAdminPropertiesFormat.protocol = SecurityConfigurationRuleProtocol.fromString(reader.getString());
                    continue;
                }
                if ("access".equals(fieldName)) {
                    deserializedAdminPropertiesFormat.access = SecurityConfigurationRuleAccess.fromString(reader.getString());
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedAdminPropertiesFormat.priority = reader.getInt();
                    continue;
                }
                if ("direction".equals(fieldName)) {
                    deserializedAdminPropertiesFormat.direction = SecurityConfigurationRuleDirection.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAdminPropertiesFormat.description = reader.getString();
                    continue;
                }
                if ("sources".equals(fieldName)) {
                    List sources;
                    deserializedAdminPropertiesFormat.sources = sources = reader.readArray(reader1 -> AddressPrefixItem.fromJson(reader1));
                    continue;
                }
                if ("destinations".equals(fieldName)) {
                    List destinations;
                    deserializedAdminPropertiesFormat.destinations = destinations = reader.readArray(reader1 -> AddressPrefixItem.fromJson(reader1));
                    continue;
                }
                if ("sourcePortRanges".equals(fieldName)) {
                    List sourcePortRanges;
                    deserializedAdminPropertiesFormat.sourcePortRanges = sourcePortRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("destinationPortRanges".equals(fieldName)) {
                    List destinationPortRanges;
                    deserializedAdminPropertiesFormat.destinationPortRanges = destinationPortRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAdminPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedAdminPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdminPropertiesFormat;
        });
    }
}

