/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.implementation.ApplicationGatewaysImpl;
import com.azure.resourcemanager.network.implementation.ApplicationSecurityGroupsImpl;
import com.azure.resourcemanager.network.implementation.DdosProtectionPlansImpl;
import com.azure.resourcemanager.network.implementation.ExpressRouteCircuitsImpl;
import com.azure.resourcemanager.network.implementation.ExpressRouteCrossConnectionsImpl;
import com.azure.resourcemanager.network.implementation.LoadBalancersImpl;
import com.azure.resourcemanager.network.implementation.LocalNetworkGatewaysImpl;
import com.azure.resourcemanager.network.implementation.NetworkInterfacesImpl;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientBuilder;
import com.azure.resourcemanager.network.implementation.NetworkProfilesImpl;
import com.azure.resourcemanager.network.implementation.NetworkSecurityGroupsImpl;
import com.azure.resourcemanager.network.implementation.NetworkUsagesImpl;
import com.azure.resourcemanager.network.implementation.NetworkWatchersImpl;
import com.azure.resourcemanager.network.implementation.NetworksImpl;
import com.azure.resourcemanager.network.implementation.PrivateEndpointsImpl;
import com.azure.resourcemanager.network.implementation.PublicIpAddressesImpl;
import com.azure.resourcemanager.network.implementation.PublicIpPrefixesImpl;
import com.azure.resourcemanager.network.implementation.RouteFiltersImpl;
import com.azure.resourcemanager.network.implementation.RouteTablesImpl;
import com.azure.resourcemanager.network.implementation.VirtualNetworkGatewaysImpl;
import com.azure.resourcemanager.network.implementation.WebApplicationFirewallPoliciesImpl;
import com.azure.resourcemanager.network.models.ApplicationGateways;
import com.azure.resourcemanager.network.models.ApplicationSecurityGroups;
import com.azure.resourcemanager.network.models.DdosProtectionPlans;
import com.azure.resourcemanager.network.models.ExpressRouteCircuits;
import com.azure.resourcemanager.network.models.ExpressRouteCrossConnections;
import com.azure.resourcemanager.network.models.LoadBalancers;
import com.azure.resourcemanager.network.models.LocalNetworkGateways;
import com.azure.resourcemanager.network.models.NetworkInterfaces;
import com.azure.resourcemanager.network.models.NetworkProfiles;
import com.azure.resourcemanager.network.models.NetworkSecurityGroups;
import com.azure.resourcemanager.network.models.NetworkUsages;
import com.azure.resourcemanager.network.models.NetworkWatchers;
import com.azure.resourcemanager.network.models.Networks;
import com.azure.resourcemanager.network.models.PrivateEndpoints;
import com.azure.resourcemanager.network.models.PublicIpAddresses;
import com.azure.resourcemanager.network.models.PublicIpPrefixes;
import com.azure.resourcemanager.network.models.RouteFilters;
import com.azure.resourcemanager.network.models.RouteTables;
import com.azure.resourcemanager.network.models.VirtualNetworkGateways;
import com.azure.resourcemanager.network.models.WebApplicationFirewallPolicies;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import java.util.Objects;

public final class NetworkManager
extends Manager<NetworkManagementClient> {
    private PublicIpAddresses publicIPAddresses;
    private PublicIpPrefixes publicIpPrefixes;
    private Networks networks;
    private NetworkSecurityGroups networkSecurityGroups;
    private NetworkInterfaces networkInterfaces;
    private LoadBalancers loadBalancers;
    private RouteTables routeTables;
    private ApplicationGateways applicationGateways;
    private NetworkUsages networkUsages;
    private NetworkWatchers networkWatchers;
    private VirtualNetworkGateways virtualNetworkGateways;
    private LocalNetworkGateways localNetworkGateways;
    private ExpressRouteCircuits expressRouteCircuits;
    private ApplicationSecurityGroups applicationSecurityGroups;
    private RouteFilters routeFilters;
    private DdosProtectionPlans ddosProtectionPlans;
    private ExpressRouteCrossConnections expressRouteCrossConnections;
    private PrivateEndpoints privateEndpoints;
    private NetworkProfiles networkProfiles;
    private WebApplicationFirewallPolicies webApplicationFirewallPolicies;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static NetworkManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return NetworkManager.authenticate(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    public static NetworkManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new NetworkManager(httpPipeline, profile);
    }

    private NetworkManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, (Object)new NetworkManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
    }

    public RouteTables routeTables() {
        if (this.routeTables == null) {
            this.routeTables = new RouteTablesImpl(this);
        }
        return this.routeTables;
    }

    public Networks networks() {
        if (this.networks == null) {
            this.networks = new NetworksImpl(this);
        }
        return this.networks;
    }

    public NetworkSecurityGroups networkSecurityGroups() {
        if (this.networkSecurityGroups == null) {
            this.networkSecurityGroups = new NetworkSecurityGroupsImpl(this);
        }
        return this.networkSecurityGroups;
    }

    public PublicIpAddresses publicIpAddresses() {
        if (this.publicIPAddresses == null) {
            this.publicIPAddresses = new PublicIpAddressesImpl(this);
        }
        return this.publicIPAddresses;
    }

    public PublicIpPrefixes publicIpPrefixes() {
        if (this.publicIpPrefixes == null) {
            this.publicIpPrefixes = new PublicIpPrefixesImpl(this);
        }
        return this.publicIpPrefixes;
    }

    public NetworkInterfaces networkInterfaces() {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new NetworkInterfacesImpl(this);
        }
        return this.networkInterfaces;
    }

    public ApplicationGateways applicationGateways() {
        if (this.applicationGateways == null) {
            this.applicationGateways = new ApplicationGatewaysImpl(this);
        }
        return this.applicationGateways;
    }

    public LoadBalancers loadBalancers() {
        if (this.loadBalancers == null) {
            this.loadBalancers = new LoadBalancersImpl(this);
        }
        return this.loadBalancers;
    }

    public NetworkUsages usages() {
        if (this.networkUsages == null) {
            this.networkUsages = new NetworkUsagesImpl((NetworkManagementClient)this.serviceClient());
        }
        return this.networkUsages;
    }

    public NetworkWatchers networkWatchers() {
        if (this.networkWatchers == null) {
            this.networkWatchers = new NetworkWatchersImpl(this);
        }
        return this.networkWatchers;
    }

    public VirtualNetworkGateways virtualNetworkGateways() {
        if (this.virtualNetworkGateways == null) {
            this.virtualNetworkGateways = new VirtualNetworkGatewaysImpl(this);
        }
        return this.virtualNetworkGateways;
    }

    public LocalNetworkGateways localNetworkGateways() {
        if (this.localNetworkGateways == null) {
            this.localNetworkGateways = new LocalNetworkGatewaysImpl(this);
        }
        return this.localNetworkGateways;
    }

    public ExpressRouteCircuits expressRouteCircuits() {
        if (this.expressRouteCircuits == null) {
            this.expressRouteCircuits = new ExpressRouteCircuitsImpl(this);
        }
        return this.expressRouteCircuits;
    }

    public ApplicationSecurityGroups applicationSecurityGroups() {
        if (this.applicationSecurityGroups == null) {
            this.applicationSecurityGroups = new ApplicationSecurityGroupsImpl(this);
        }
        return this.applicationSecurityGroups;
    }

    public RouteFilters routeFilters() {
        if (this.routeFilters == null) {
            this.routeFilters = new RouteFiltersImpl(this);
        }
        return this.routeFilters;
    }

    public DdosProtectionPlans ddosProtectionPlans() {
        if (this.ddosProtectionPlans == null) {
            this.ddosProtectionPlans = new DdosProtectionPlansImpl(this);
        }
        return this.ddosProtectionPlans;
    }

    public ExpressRouteCrossConnections expressRouteCrossConnections() {
        if (this.expressRouteCrossConnections == null) {
            this.expressRouteCrossConnections = new ExpressRouteCrossConnectionsImpl(this);
        }
        return this.expressRouteCrossConnections;
    }

    public PrivateEndpoints privateEndpoints() {
        if (this.privateEndpoints == null) {
            this.privateEndpoints = new PrivateEndpointsImpl(this);
        }
        return this.privateEndpoints;
    }

    public NetworkProfiles networkProfiles() {
        if (this.networkProfiles == null) {
            this.networkProfiles = new NetworkProfilesImpl(this);
        }
        return this.networkProfiles;
    }

    public WebApplicationFirewallPolicies webApplicationFirewallPolicies() {
        if (this.webApplicationFirewallPolicies == null) {
            this.webApplicationFirewallPolicies = new WebApplicationFirewallPoliciesImpl(this);
        }
        return this.webApplicationFirewallPolicies;
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public NetworkManager authenticate(TokenCredential credential, AzureProfile profile) {
            return NetworkManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public NetworkManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

