// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Vpn Connection packet capture parameters supplied to stop packet capture on gateway connection.
 */
@Fluent
public final class VpnConnectionPacketCaptureStopParameters
    implements JsonSerializable<VpnConnectionPacketCaptureStopParameters> {
    /*
     * SAS url for packet capture on vpn connection.
     */
    private String sasUrl;

    /*
     * List of site link connection names.
     */
    private List<String> linkConnectionNames;

    /**
     * Creates an instance of VpnConnectionPacketCaptureStopParameters class.
     */
    public VpnConnectionPacketCaptureStopParameters() {
    }

    /**
     * Get the sasUrl property: SAS url for packet capture on vpn connection.
     * 
     * @return the sasUrl value.
     */
    public String sasUrl() {
        return this.sasUrl;
    }

    /**
     * Set the sasUrl property: SAS url for packet capture on vpn connection.
     * 
     * @param sasUrl the sasUrl value to set.
     * @return the VpnConnectionPacketCaptureStopParameters object itself.
     */
    public VpnConnectionPacketCaptureStopParameters withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    /**
     * Get the linkConnectionNames property: List of site link connection names.
     * 
     * @return the linkConnectionNames value.
     */
    public List<String> linkConnectionNames() {
        return this.linkConnectionNames;
    }

    /**
     * Set the linkConnectionNames property: List of site link connection names.
     * 
     * @param linkConnectionNames the linkConnectionNames value to set.
     * @return the VpnConnectionPacketCaptureStopParameters object itself.
     */
    public VpnConnectionPacketCaptureStopParameters withLinkConnectionNames(List<String> linkConnectionNames) {
        this.linkConnectionNames = linkConnectionNames;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sasUrl", this.sasUrl);
        jsonWriter.writeArrayField("linkConnectionNames", this.linkConnectionNames,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnConnectionPacketCaptureStopParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnConnectionPacketCaptureStopParameters if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnConnectionPacketCaptureStopParameters.
     */
    public static VpnConnectionPacketCaptureStopParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnConnectionPacketCaptureStopParameters deserializedVpnConnectionPacketCaptureStopParameters
                = new VpnConnectionPacketCaptureStopParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sasUrl".equals(fieldName)) {
                    deserializedVpnConnectionPacketCaptureStopParameters.sasUrl = reader.getString();
                } else if ("linkConnectionNames".equals(fieldName)) {
                    List<String> linkConnectionNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedVpnConnectionPacketCaptureStopParameters.linkConnectionNames = linkConnectionNames;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnConnectionPacketCaptureStopParameters;
        });
    }
}
