// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration for static routes on this HubVnetConnectionConfiguration for static routes on this HubVnetConnection.
 */
@Fluent
public final class StaticRoutesConfig implements JsonSerializable<StaticRoutesConfig> {
    /*
     * Boolean indicating whether static routes on this connection are automatically propagate to route tables which
     * this connection propagates to.
     */
    private Boolean propagateStaticRoutes;

    /*
     * Parameter determining whether NVA in spoke vnet is bypassed for traffic with destination in spoke.
     */
    private VnetLocalRouteOverrideCriteria vnetLocalRouteOverrideCriteria;

    /**
     * Creates an instance of StaticRoutesConfig class.
     */
    public StaticRoutesConfig() {
    }

    /**
     * Get the propagateStaticRoutes property: Boolean indicating whether static routes on this connection are
     * automatically propagate to route tables which this connection propagates to.
     * 
     * @return the propagateStaticRoutes value.
     */
    public Boolean propagateStaticRoutes() {
        return this.propagateStaticRoutes;
    }

    /**
     * Get the vnetLocalRouteOverrideCriteria property: Parameter determining whether NVA in spoke vnet is bypassed for
     * traffic with destination in spoke.
     * 
     * @return the vnetLocalRouteOverrideCriteria value.
     */
    public VnetLocalRouteOverrideCriteria vnetLocalRouteOverrideCriteria() {
        return this.vnetLocalRouteOverrideCriteria;
    }

    /**
     * Set the vnetLocalRouteOverrideCriteria property: Parameter determining whether NVA in spoke vnet is bypassed for
     * traffic with destination in spoke.
     * 
     * @param vnetLocalRouteOverrideCriteria the vnetLocalRouteOverrideCriteria value to set.
     * @return the StaticRoutesConfig object itself.
     */
    public StaticRoutesConfig
        withVnetLocalRouteOverrideCriteria(VnetLocalRouteOverrideCriteria vnetLocalRouteOverrideCriteria) {
        this.vnetLocalRouteOverrideCriteria = vnetLocalRouteOverrideCriteria;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vnetLocalRouteOverrideCriteria",
            this.vnetLocalRouteOverrideCriteria == null ? null : this.vnetLocalRouteOverrideCriteria.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticRoutesConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticRoutesConfig if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the StaticRoutesConfig.
     */
    public static StaticRoutesConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticRoutesConfig deserializedStaticRoutesConfig = new StaticRoutesConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("propagateStaticRoutes".equals(fieldName)) {
                    deserializedStaticRoutesConfig.propagateStaticRoutes = reader.getNullable(JsonReader::getBoolean);
                } else if ("vnetLocalRouteOverrideCriteria".equals(fieldName)) {
                    deserializedStaticRoutesConfig.vnetLocalRouteOverrideCriteria
                        = VnetLocalRouteOverrideCriteria.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticRoutesConfig;
        });
    }
}
