// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Routing rule destination type.
 */
public final class RoutingRuleDestinationType extends ExpandableStringEnum<RoutingRuleDestinationType> {
    /**
     * Static value AddressPrefix for RoutingRuleDestinationType.
     */
    public static final RoutingRuleDestinationType ADDRESS_PREFIX = fromString("AddressPrefix");

    /**
     * Static value ServiceTag for RoutingRuleDestinationType.
     */
    public static final RoutingRuleDestinationType SERVICE_TAG = fromString("ServiceTag");

    /**
     * Creates a new instance of RoutingRuleDestinationType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public RoutingRuleDestinationType() {
    }

    /**
     * Creates or finds a RoutingRuleDestinationType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding RoutingRuleDestinationType.
     */
    public static RoutingRuleDestinationType fromString(String name) {
        return fromString(name, RoutingRuleDestinationType.class);
    }

    /**
     * Gets known RoutingRuleDestinationType values.
     * 
     * @return known RoutingRuleDestinationType values.
     */
    public static Collection<RoutingRuleDestinationType> values() {
        return values(RoutingRuleDestinationType.class);
    }
}
