// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Scope of Network Manager.
 */
@Fluent
public final class NetworkManagerPropertiesNetworkManagerScopes
    implements JsonSerializable<NetworkManagerPropertiesNetworkManagerScopes> {
    /*
     * List of management groups.
     */
    private List<String> managementGroups;

    /*
     * List of subscriptions.
     */
    private List<String> subscriptions;

    /*
     * List of cross tenant scopes.
     */
    private List<CrossTenantScopes> crossTenantScopes;

    /**
     * Creates an instance of NetworkManagerPropertiesNetworkManagerScopes class.
     */
    public NetworkManagerPropertiesNetworkManagerScopes() {
    }

    /**
     * Get the managementGroups property: List of management groups.
     * 
     * @return the managementGroups value.
     */
    public List<String> managementGroups() {
        return this.managementGroups;
    }

    /**
     * Set the managementGroups property: List of management groups.
     * 
     * @param managementGroups the managementGroups value to set.
     * @return the NetworkManagerPropertiesNetworkManagerScopes object itself.
     */
    public NetworkManagerPropertiesNetworkManagerScopes withManagementGroups(List<String> managementGroups) {
        this.managementGroups = managementGroups;
        return this;
    }

    /**
     * Get the subscriptions property: List of subscriptions.
     * 
     * @return the subscriptions value.
     */
    public List<String> subscriptions() {
        return this.subscriptions;
    }

    /**
     * Set the subscriptions property: List of subscriptions.
     * 
     * @param subscriptions the subscriptions value to set.
     * @return the NetworkManagerPropertiesNetworkManagerScopes object itself.
     */
    public NetworkManagerPropertiesNetworkManagerScopes withSubscriptions(List<String> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    /**
     * Get the crossTenantScopes property: List of cross tenant scopes.
     * 
     * @return the crossTenantScopes value.
     */
    public List<CrossTenantScopes> crossTenantScopes() {
        return this.crossTenantScopes;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (crossTenantScopes() != null) {
            crossTenantScopes().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("managementGroups", this.managementGroups,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("subscriptions", this.subscriptions,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkManagerPropertiesNetworkManagerScopes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkManagerPropertiesNetworkManagerScopes if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkManagerPropertiesNetworkManagerScopes.
     */
    public static NetworkManagerPropertiesNetworkManagerScopes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkManagerPropertiesNetworkManagerScopes deserializedNetworkManagerPropertiesNetworkManagerScopes
                = new NetworkManagerPropertiesNetworkManagerScopes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("managementGroups".equals(fieldName)) {
                    List<String> managementGroups = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkManagerPropertiesNetworkManagerScopes.managementGroups = managementGroups;
                } else if ("subscriptions".equals(fieldName)) {
                    List<String> subscriptions = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkManagerPropertiesNetworkManagerScopes.subscriptions = subscriptions;
                } else if ("crossTenantScopes".equals(fieldName)) {
                    List<CrossTenantScopes> crossTenantScopes
                        = reader.readArray(reader1 -> CrossTenantScopes.fromJson(reader1));
                    deserializedNetworkManagerPropertiesNetworkManagerScopes.crossTenantScopes = crossTenantScopes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkManagerPropertiesNetworkManagerScopes;
        });
    }
}
