// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Individual port mappings for inbound NAT rule created for backend pool.
 */
@Fluent
public final class NatRulePortMapping implements JsonSerializable<NatRulePortMapping> {
    /*
     * Name of inbound NAT rule.
     */
    private String inboundNatRuleName;

    /*
     * Frontend port.
     */
    private Integer frontendPort;

    /*
     * Backend port.
     */
    private Integer backendPort;

    /**
     * Creates an instance of NatRulePortMapping class.
     */
    public NatRulePortMapping() {
    }

    /**
     * Get the inboundNatRuleName property: Name of inbound NAT rule.
     * 
     * @return the inboundNatRuleName value.
     */
    public String inboundNatRuleName() {
        return this.inboundNatRuleName;
    }

    /**
     * Set the inboundNatRuleName property: Name of inbound NAT rule.
     * 
     * @param inboundNatRuleName the inboundNatRuleName value to set.
     * @return the NatRulePortMapping object itself.
     */
    public NatRulePortMapping withInboundNatRuleName(String inboundNatRuleName) {
        this.inboundNatRuleName = inboundNatRuleName;
        return this;
    }

    /**
     * Get the frontendPort property: Frontend port.
     * 
     * @return the frontendPort value.
     */
    public Integer frontendPort() {
        return this.frontendPort;
    }

    /**
     * Set the frontendPort property: Frontend port.
     * 
     * @param frontendPort the frontendPort value to set.
     * @return the NatRulePortMapping object itself.
     */
    public NatRulePortMapping withFrontendPort(Integer frontendPort) {
        this.frontendPort = frontendPort;
        return this;
    }

    /**
     * Get the backendPort property: Backend port.
     * 
     * @return the backendPort value.
     */
    public Integer backendPort() {
        return this.backendPort;
    }

    /**
     * Set the backendPort property: Backend port.
     * 
     * @param backendPort the backendPort value to set.
     * @return the NatRulePortMapping object itself.
     */
    public NatRulePortMapping withBackendPort(Integer backendPort) {
        this.backendPort = backendPort;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("inboundNatRuleName", this.inboundNatRuleName);
        jsonWriter.writeNumberField("frontendPort", this.frontendPort);
        jsonWriter.writeNumberField("backendPort", this.backendPort);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NatRulePortMapping from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NatRulePortMapping if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the NatRulePortMapping.
     */
    public static NatRulePortMapping fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NatRulePortMapping deserializedNatRulePortMapping = new NatRulePortMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("inboundNatRuleName".equals(fieldName)) {
                    deserializedNatRulePortMapping.inboundNatRuleName = reader.getString();
                } else if ("frontendPort".equals(fieldName)) {
                    deserializedNatRulePortMapping.frontendPort = reader.getNullable(JsonReader::getInt);
                } else if ("backendPort".equals(fieldName)) {
                    deserializedNatRulePortMapping.backendPort = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNatRulePortMapping;
        });
    }
}
