// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specifies the peering configuration.
 */
@Fluent
public final class ExpressRouteCircuitPeeringConfig implements JsonSerializable<ExpressRouteCircuitPeeringConfig> {
    /*
     * The reference to AdvertisedPublicPrefixes.
     */
    private List<String> advertisedPublicPrefixes;

    /*
     * The communities of bgp peering. Specified for microsoft peering.
     */
    private List<String> advertisedCommunities;

    /*
     * The advertised public prefix state of the Peering resource.
     */
    private ExpressRouteCircuitPeeringAdvertisedPublicPrefixState advertisedPublicPrefixesState;

    /*
     * The legacy mode of the peering.
     */
    private Integer legacyMode;

    /*
     * The CustomerASN of the peering.
     */
    private Integer customerAsn;

    /*
     * The RoutingRegistryName of the configuration.
     */
    private String routingRegistryName;

    /**
     * Creates an instance of ExpressRouteCircuitPeeringConfig class.
     */
    public ExpressRouteCircuitPeeringConfig() {
    }

    /**
     * Get the advertisedPublicPrefixes property: The reference to AdvertisedPublicPrefixes.
     * 
     * @return the advertisedPublicPrefixes value.
     */
    public List<String> advertisedPublicPrefixes() {
        return this.advertisedPublicPrefixes;
    }

    /**
     * Set the advertisedPublicPrefixes property: The reference to AdvertisedPublicPrefixes.
     * 
     * @param advertisedPublicPrefixes the advertisedPublicPrefixes value to set.
     * @return the ExpressRouteCircuitPeeringConfig object itself.
     */
    public ExpressRouteCircuitPeeringConfig withAdvertisedPublicPrefixes(List<String> advertisedPublicPrefixes) {
        this.advertisedPublicPrefixes = advertisedPublicPrefixes;
        return this;
    }

    /**
     * Get the advertisedCommunities property: The communities of bgp peering. Specified for microsoft peering.
     * 
     * @return the advertisedCommunities value.
     */
    public List<String> advertisedCommunities() {
        return this.advertisedCommunities;
    }

    /**
     * Set the advertisedCommunities property: The communities of bgp peering. Specified for microsoft peering.
     * 
     * @param advertisedCommunities the advertisedCommunities value to set.
     * @return the ExpressRouteCircuitPeeringConfig object itself.
     */
    public ExpressRouteCircuitPeeringConfig withAdvertisedCommunities(List<String> advertisedCommunities) {
        this.advertisedCommunities = advertisedCommunities;
        return this;
    }

    /**
     * Get the advertisedPublicPrefixesState property: The advertised public prefix state of the Peering resource.
     * 
     * @return the advertisedPublicPrefixesState value.
     */
    public ExpressRouteCircuitPeeringAdvertisedPublicPrefixState advertisedPublicPrefixesState() {
        return this.advertisedPublicPrefixesState;
    }

    /**
     * Get the legacyMode property: The legacy mode of the peering.
     * 
     * @return the legacyMode value.
     */
    public Integer legacyMode() {
        return this.legacyMode;
    }

    /**
     * Set the legacyMode property: The legacy mode of the peering.
     * 
     * @param legacyMode the legacyMode value to set.
     * @return the ExpressRouteCircuitPeeringConfig object itself.
     */
    public ExpressRouteCircuitPeeringConfig withLegacyMode(Integer legacyMode) {
        this.legacyMode = legacyMode;
        return this;
    }

    /**
     * Get the customerAsn property: The CustomerASN of the peering.
     * 
     * @return the customerAsn value.
     */
    public Integer customerAsn() {
        return this.customerAsn;
    }

    /**
     * Set the customerAsn property: The CustomerASN of the peering.
     * 
     * @param customerAsn the customerAsn value to set.
     * @return the ExpressRouteCircuitPeeringConfig object itself.
     */
    public ExpressRouteCircuitPeeringConfig withCustomerAsn(Integer customerAsn) {
        this.customerAsn = customerAsn;
        return this;
    }

    /**
     * Get the routingRegistryName property: The RoutingRegistryName of the configuration.
     * 
     * @return the routingRegistryName value.
     */
    public String routingRegistryName() {
        return this.routingRegistryName;
    }

    /**
     * Set the routingRegistryName property: The RoutingRegistryName of the configuration.
     * 
     * @param routingRegistryName the routingRegistryName value to set.
     * @return the ExpressRouteCircuitPeeringConfig object itself.
     */
    public ExpressRouteCircuitPeeringConfig withRoutingRegistryName(String routingRegistryName) {
        this.routingRegistryName = routingRegistryName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("advertisedPublicPrefixes", this.advertisedPublicPrefixes,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("advertisedCommunities", this.advertisedCommunities,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("legacyMode", this.legacyMode);
        jsonWriter.writeNumberField("customerASN", this.customerAsn);
        jsonWriter.writeStringField("routingRegistryName", this.routingRegistryName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteCircuitPeeringConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteCircuitPeeringConfig if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteCircuitPeeringConfig.
     */
    public static ExpressRouteCircuitPeeringConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteCircuitPeeringConfig deserializedExpressRouteCircuitPeeringConfig
                = new ExpressRouteCircuitPeeringConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("advertisedPublicPrefixes".equals(fieldName)) {
                    List<String> advertisedPublicPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedExpressRouteCircuitPeeringConfig.advertisedPublicPrefixes = advertisedPublicPrefixes;
                } else if ("advertisedCommunities".equals(fieldName)) {
                    List<String> advertisedCommunities = reader.readArray(reader1 -> reader1.getString());
                    deserializedExpressRouteCircuitPeeringConfig.advertisedCommunities = advertisedCommunities;
                } else if ("advertisedPublicPrefixesState".equals(fieldName)) {
                    deserializedExpressRouteCircuitPeeringConfig.advertisedPublicPrefixesState
                        = ExpressRouteCircuitPeeringAdvertisedPublicPrefixState.fromString(reader.getString());
                } else if ("legacyMode".equals(fieldName)) {
                    deserializedExpressRouteCircuitPeeringConfig.legacyMode = reader.getNullable(JsonReader::getInt);
                } else if ("customerASN".equals(fieldName)) {
                    deserializedExpressRouteCircuitPeeringConfig.customerAsn = reader.getNullable(JsonReader::getInt);
                } else if ("routingRegistryName".equals(fieldName)) {
                    deserializedExpressRouteCircuitPeeringConfig.routingRegistryName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteCircuitPeeringConfig;
        });
    }
}
