// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The operation mode for Threat Intel.
 */
public final class AzureFirewallThreatIntelMode extends ExpandableStringEnum<AzureFirewallThreatIntelMode> {
    /**
     * Static value Alert for AzureFirewallThreatIntelMode.
     */
    public static final AzureFirewallThreatIntelMode ALERT = fromString("Alert");

    /**
     * Static value Deny for AzureFirewallThreatIntelMode.
     */
    public static final AzureFirewallThreatIntelMode DENY = fromString("Deny");

    /**
     * Static value Off for AzureFirewallThreatIntelMode.
     */
    public static final AzureFirewallThreatIntelMode OFF = fromString("Off");

    /**
     * Creates a new instance of AzureFirewallThreatIntelMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AzureFirewallThreatIntelMode() {
    }

    /**
     * Creates or finds a AzureFirewallThreatIntelMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AzureFirewallThreatIntelMode.
     */
    public static AzureFirewallThreatIntelMode fromString(String name) {
        return fromString(name, AzureFirewallThreatIntelMode.class);
    }

    /**
     * Gets known AzureFirewallThreatIntelMode values.
     * 
     * @return known AzureFirewallThreatIntelMode values.
     */
    public static Collection<AzureFirewallThreatIntelMode> values() {
        return values(AzureFirewallThreatIntelMode.class);
    }
}
