// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayLoadDistributionTargetPropertiesFormat;
import java.io.IOException;

/**
 * Load Distribution Target of an application gateway.
 */
@Fluent
public final class ApplicationGatewayLoadDistributionTarget extends SubResource {
    /*
     * Properties of the application gateway load distribution target.
     */
    private ApplicationGatewayLoadDistributionTargetPropertiesFormat innerProperties;

    /*
     * Name of the load distribution policy that is unique within an Application Gateway.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ApplicationGatewayLoadDistributionTarget class.
     */
    public ApplicationGatewayLoadDistributionTarget() {
    }

    /**
     * Get the innerProperties property: Properties of the application gateway load distribution target.
     * 
     * @return the innerProperties value.
     */
    private ApplicationGatewayLoadDistributionTargetPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Name of the load distribution policy that is unique within an Application Gateway.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the load distribution policy that is unique within an Application Gateway.
     * 
     * @param name the name value to set.
     * @return the ApplicationGatewayLoadDistributionTarget object itself.
     */
    public ApplicationGatewayLoadDistributionTarget withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Type of the resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationGatewayLoadDistributionTarget withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the weightPerServer property: Weight per server. Range between 1 and 100.
     * 
     * @return the weightPerServer value.
     */
    public Integer weightPerServer() {
        return this.innerProperties() == null ? null : this.innerProperties().weightPerServer();
    }

    /**
     * Set the weightPerServer property: Weight per server. Range between 1 and 100.
     * 
     * @param weightPerServer the weightPerServer value to set.
     * @return the ApplicationGatewayLoadDistributionTarget object itself.
     */
    public ApplicationGatewayLoadDistributionTarget withWeightPerServer(Integer weightPerServer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayLoadDistributionTargetPropertiesFormat();
        }
        this.innerProperties().withWeightPerServer(weightPerServer);
        return this;
    }

    /**
     * Get the backendAddressPool property: Backend address pool resource of the application gateway.
     * 
     * @return the backendAddressPool value.
     */
    public SubResource backendAddressPool() {
        return this.innerProperties() == null ? null : this.innerProperties().backendAddressPool();
    }

    /**
     * Set the backendAddressPool property: Backend address pool resource of the application gateway.
     * 
     * @param backendAddressPool the backendAddressPool value to set.
     * @return the ApplicationGatewayLoadDistributionTarget object itself.
     */
    public ApplicationGatewayLoadDistributionTarget withBackendAddressPool(SubResource backendAddressPool) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayLoadDistributionTargetPropertiesFormat();
        }
        this.innerProperties().withBackendAddressPool(backendAddressPool);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayLoadDistributionTarget from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayLoadDistributionTarget if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayLoadDistributionTarget.
     */
    public static ApplicationGatewayLoadDistributionTarget fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayLoadDistributionTarget deserializedApplicationGatewayLoadDistributionTarget
                = new ApplicationGatewayLoadDistributionTarget();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApplicationGatewayLoadDistributionTarget.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedApplicationGatewayLoadDistributionTarget.innerProperties
                        = ApplicationGatewayLoadDistributionTargetPropertiesFormat.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedApplicationGatewayLoadDistributionTarget.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedApplicationGatewayLoadDistributionTarget.etag = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApplicationGatewayLoadDistributionTarget.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayLoadDistributionTarget;
        });
    }
}
