// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Application gateway BackendHealth pool.
 */
@Fluent
public final class ApplicationGatewayBackendHealthPool
    implements JsonSerializable<ApplicationGatewayBackendHealthPool> {
    /*
     * Reference to an ApplicationGatewayBackendAddressPool resource.
     */
    private ApplicationGatewayBackendAddressPool backendAddressPool;

    /*
     * List of ApplicationGatewayBackendHealthHttpSettings resources.
     */
    private List<ApplicationGatewayBackendHealthHttpSettings> backendHttpSettingsCollection;

    /**
     * Creates an instance of ApplicationGatewayBackendHealthPool class.
     */
    public ApplicationGatewayBackendHealthPool() {
    }

    /**
     * Get the backendAddressPool property: Reference to an ApplicationGatewayBackendAddressPool resource.
     * 
     * @return the backendAddressPool value.
     */
    public ApplicationGatewayBackendAddressPool backendAddressPool() {
        return this.backendAddressPool;
    }

    /**
     * Set the backendAddressPool property: Reference to an ApplicationGatewayBackendAddressPool resource.
     * 
     * @param backendAddressPool the backendAddressPool value to set.
     * @return the ApplicationGatewayBackendHealthPool object itself.
     */
    public ApplicationGatewayBackendHealthPool
        withBackendAddressPool(ApplicationGatewayBackendAddressPool backendAddressPool) {
        this.backendAddressPool = backendAddressPool;
        return this;
    }

    /**
     * Get the backendHttpSettingsCollection property: List of ApplicationGatewayBackendHealthHttpSettings resources.
     * 
     * @return the backendHttpSettingsCollection value.
     */
    public List<ApplicationGatewayBackendHealthHttpSettings> backendHttpSettingsCollection() {
        return this.backendHttpSettingsCollection;
    }

    /**
     * Set the backendHttpSettingsCollection property: List of ApplicationGatewayBackendHealthHttpSettings resources.
     * 
     * @param backendHttpSettingsCollection the backendHttpSettingsCollection value to set.
     * @return the ApplicationGatewayBackendHealthPool object itself.
     */
    public ApplicationGatewayBackendHealthPool withBackendHttpSettingsCollection(
        List<ApplicationGatewayBackendHealthHttpSettings> backendHttpSettingsCollection) {
        this.backendHttpSettingsCollection = backendHttpSettingsCollection;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (backendAddressPool() != null) {
            backendAddressPool().validate();
        }
        if (backendHttpSettingsCollection() != null) {
            backendHttpSettingsCollection().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("backendAddressPool", this.backendAddressPool);
        jsonWriter.writeArrayField("backendHttpSettingsCollection", this.backendHttpSettingsCollection,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayBackendHealthPool from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayBackendHealthPool if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayBackendHealthPool.
     */
    public static ApplicationGatewayBackendHealthPool fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayBackendHealthPool deserializedApplicationGatewayBackendHealthPool
                = new ApplicationGatewayBackendHealthPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("backendAddressPool".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHealthPool.backendAddressPool
                        = ApplicationGatewayBackendAddressPool.fromJson(reader);
                } else if ("backendHttpSettingsCollection".equals(fieldName)) {
                    List<ApplicationGatewayBackendHealthHttpSettings> backendHttpSettingsCollection
                        = reader.readArray(reader1 -> ApplicationGatewayBackendHealthHttpSettings.fromJson(reader1));
                    deserializedApplicationGatewayBackendHealthPool.backendHttpSettingsCollection
                        = backendHttpSettingsCollection;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayBackendHealthPool;
        });
    }
}
