// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.CustomDnsConfigPropertiesFormat;
import com.azure.resourcemanager.network.models.PrivateEndpointIpConfiguration;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnection;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of the private endpoint.
 */
@Fluent
public final class PrivateEndpointPropertiesInner implements JsonSerializable<PrivateEndpointPropertiesInner> {
    /*
     * The ID of the subnet from which the private IP will be allocated.
     */
    private SubnetInner subnet;

    /*
     * An array of references to the network interfaces created for this private endpoint.
     */
    private List<NetworkInterfaceInner> networkInterfaces;

    /*
     * The provisioning state of the private endpoint resource.
     */
    private ProvisioningState provisioningState;

    /*
     * A grouping of information about the connection to the remote resource.
     */
    private List<PrivateLinkServiceConnection> privateLinkServiceConnections;

    /*
     * A grouping of information about the connection to the remote resource. Used when the network admin does not have
     * access to approve connections to the remote resource.
     */
    private List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections;

    /*
     * An array of custom dns configurations.
     */
    private List<CustomDnsConfigPropertiesFormat> customDnsConfigs;

    /*
     * Application security groups in which the private endpoint IP configuration is included.
     */
    private List<ApplicationSecurityGroupInner> applicationSecurityGroups;

    /*
     * A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's
     * endpoints.
     */
    private List<PrivateEndpointIpConfiguration> ipConfigurations;

    /*
     * The custom name of the network interface attached to the private endpoint.
     */
    private String customNetworkInterfaceName;

    /**
     * Creates an instance of PrivateEndpointPropertiesInner class.
     */
    public PrivateEndpointPropertiesInner() {
    }

    /**
     * Get the subnet property: The ID of the subnet from which the private IP will be allocated.
     * 
     * @return the subnet value.
     */
    public SubnetInner subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: The ID of the subnet from which the private IP will be allocated.
     * 
     * @param subnet the subnet value to set.
     * @return the PrivateEndpointPropertiesInner object itself.
     */
    public PrivateEndpointPropertiesInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the networkInterfaces property: An array of references to the network interfaces created for this private
     * endpoint.
     * 
     * @return the networkInterfaces value.
     */
    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.networkInterfaces;
    }

    /**
     * Get the provisioningState property: The provisioning state of the private endpoint resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the privateLinkServiceConnections property: A grouping of information about the connection to the remote
     * resource.
     * 
     * @return the privateLinkServiceConnections value.
     */
    public List<PrivateLinkServiceConnection> privateLinkServiceConnections() {
        return this.privateLinkServiceConnections;
    }

    /**
     * Set the privateLinkServiceConnections property: A grouping of information about the connection to the remote
     * resource.
     * 
     * @param privateLinkServiceConnections the privateLinkServiceConnections value to set.
     * @return the PrivateEndpointPropertiesInner object itself.
     */
    public PrivateEndpointPropertiesInner
        withPrivateLinkServiceConnections(List<PrivateLinkServiceConnection> privateLinkServiceConnections) {
        this.privateLinkServiceConnections = privateLinkServiceConnections;
        return this;
    }

    /**
     * Get the manualPrivateLinkServiceConnections property: A grouping of information about the connection to the
     * remote resource. Used when the network admin does not have access to approve connections to the remote resource.
     * 
     * @return the manualPrivateLinkServiceConnections value.
     */
    public List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections() {
        return this.manualPrivateLinkServiceConnections;
    }

    /**
     * Set the manualPrivateLinkServiceConnections property: A grouping of information about the connection to the
     * remote resource. Used when the network admin does not have access to approve connections to the remote resource.
     * 
     * @param manualPrivateLinkServiceConnections the manualPrivateLinkServiceConnections value to set.
     * @return the PrivateEndpointPropertiesInner object itself.
     */
    public PrivateEndpointPropertiesInner withManualPrivateLinkServiceConnections(
        List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections) {
        this.manualPrivateLinkServiceConnections = manualPrivateLinkServiceConnections;
        return this;
    }

    /**
     * Get the customDnsConfigs property: An array of custom dns configurations.
     * 
     * @return the customDnsConfigs value.
     */
    public List<CustomDnsConfigPropertiesFormat> customDnsConfigs() {
        return this.customDnsConfigs;
    }

    /**
     * Set the customDnsConfigs property: An array of custom dns configurations.
     * 
     * @param customDnsConfigs the customDnsConfigs value to set.
     * @return the PrivateEndpointPropertiesInner object itself.
     */
    public PrivateEndpointPropertiesInner withCustomDnsConfigs(List<CustomDnsConfigPropertiesFormat> customDnsConfigs) {
        this.customDnsConfigs = customDnsConfigs;
        return this;
    }

    /**
     * Get the applicationSecurityGroups property: Application security groups in which the private endpoint IP
     * configuration is included.
     * 
     * @return the applicationSecurityGroups value.
     */
    public List<ApplicationSecurityGroupInner> applicationSecurityGroups() {
        return this.applicationSecurityGroups;
    }

    /**
     * Set the applicationSecurityGroups property: Application security groups in which the private endpoint IP
     * configuration is included.
     * 
     * @param applicationSecurityGroups the applicationSecurityGroups value to set.
     * @return the PrivateEndpointPropertiesInner object itself.
     */
    public PrivateEndpointPropertiesInner
        withApplicationSecurityGroups(List<ApplicationSecurityGroupInner> applicationSecurityGroups) {
        this.applicationSecurityGroups = applicationSecurityGroups;
        return this;
    }

    /**
     * Get the ipConfigurations property: A list of IP configurations of the private endpoint. This will be used to map
     * to the First Party Service's endpoints.
     * 
     * @return the ipConfigurations value.
     */
    public List<PrivateEndpointIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    /**
     * Set the ipConfigurations property: A list of IP configurations of the private endpoint. This will be used to map
     * to the First Party Service's endpoints.
     * 
     * @param ipConfigurations the ipConfigurations value to set.
     * @return the PrivateEndpointPropertiesInner object itself.
     */
    public PrivateEndpointPropertiesInner withIpConfigurations(List<PrivateEndpointIpConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    /**
     * Get the customNetworkInterfaceName property: The custom name of the network interface attached to the private
     * endpoint.
     * 
     * @return the customNetworkInterfaceName value.
     */
    public String customNetworkInterfaceName() {
        return this.customNetworkInterfaceName;
    }

    /**
     * Set the customNetworkInterfaceName property: The custom name of the network interface attached to the private
     * endpoint.
     * 
     * @param customNetworkInterfaceName the customNetworkInterfaceName value to set.
     * @return the PrivateEndpointPropertiesInner object itself.
     */
    public PrivateEndpointPropertiesInner withCustomNetworkInterfaceName(String customNetworkInterfaceName) {
        this.customNetworkInterfaceName = customNetworkInterfaceName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (subnet() != null) {
            subnet().validate();
        }
        if (networkInterfaces() != null) {
            networkInterfaces().forEach(e -> e.validate());
        }
        if (privateLinkServiceConnections() != null) {
            privateLinkServiceConnections().forEach(e -> e.validate());
        }
        if (manualPrivateLinkServiceConnections() != null) {
            manualPrivateLinkServiceConnections().forEach(e -> e.validate());
        }
        if (customDnsConfigs() != null) {
            customDnsConfigs().forEach(e -> e.validate());
        }
        if (applicationSecurityGroups() != null) {
            applicationSecurityGroups().forEach(e -> e.validate());
        }
        if (ipConfigurations() != null) {
            ipConfigurations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("subnet", this.subnet);
        jsonWriter.writeArrayField("privateLinkServiceConnections", this.privateLinkServiceConnections,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("manualPrivateLinkServiceConnections", this.manualPrivateLinkServiceConnections,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("customDnsConfigs", this.customDnsConfigs,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("applicationSecurityGroups", this.applicationSecurityGroups,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("ipConfigurations", this.ipConfigurations,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("customNetworkInterfaceName", this.customNetworkInterfaceName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateEndpointPropertiesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateEndpointPropertiesInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PrivateEndpointPropertiesInner.
     */
    public static PrivateEndpointPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateEndpointPropertiesInner deserializedPrivateEndpointPropertiesInner
                = new PrivateEndpointPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subnet".equals(fieldName)) {
                    deserializedPrivateEndpointPropertiesInner.subnet = SubnetInner.fromJson(reader);
                } else if ("networkInterfaces".equals(fieldName)) {
                    List<NetworkInterfaceInner> networkInterfaces
                        = reader.readArray(reader1 -> NetworkInterfaceInner.fromJson(reader1));
                    deserializedPrivateEndpointPropertiesInner.networkInterfaces = networkInterfaces;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedPrivateEndpointPropertiesInner.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("privateLinkServiceConnections".equals(fieldName)) {
                    List<PrivateLinkServiceConnection> privateLinkServiceConnections
                        = reader.readArray(reader1 -> PrivateLinkServiceConnection.fromJson(reader1));
                    deserializedPrivateEndpointPropertiesInner.privateLinkServiceConnections
                        = privateLinkServiceConnections;
                } else if ("manualPrivateLinkServiceConnections".equals(fieldName)) {
                    List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections
                        = reader.readArray(reader1 -> PrivateLinkServiceConnection.fromJson(reader1));
                    deserializedPrivateEndpointPropertiesInner.manualPrivateLinkServiceConnections
                        = manualPrivateLinkServiceConnections;
                } else if ("customDnsConfigs".equals(fieldName)) {
                    List<CustomDnsConfigPropertiesFormat> customDnsConfigs
                        = reader.readArray(reader1 -> CustomDnsConfigPropertiesFormat.fromJson(reader1));
                    deserializedPrivateEndpointPropertiesInner.customDnsConfigs = customDnsConfigs;
                } else if ("applicationSecurityGroups".equals(fieldName)) {
                    List<ApplicationSecurityGroupInner> applicationSecurityGroups
                        = reader.readArray(reader1 -> ApplicationSecurityGroupInner.fromJson(reader1));
                    deserializedPrivateEndpointPropertiesInner.applicationSecurityGroups = applicationSecurityGroups;
                } else if ("ipConfigurations".equals(fieldName)) {
                    List<PrivateEndpointIpConfiguration> ipConfigurations
                        = reader.readArray(reader1 -> PrivateEndpointIpConfiguration.fromJson(reader1));
                    deserializedPrivateEndpointPropertiesInner.ipConfigurations = ipConfigurations;
                } else if ("customNetworkInterfaceName".equals(fieldName)) {
                    deserializedPrivateEndpointPropertiesInner.customNetworkInterfaceName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateEndpointPropertiesInner;
        });
    }
}
