/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NetworkConfigurationDiagnosticProfile;
import com.azure.resourcemanager.network.models.NetworkSecurityGroupResult;
import java.io.IOException;

public final class NetworkConfigurationDiagnosticResult
implements JsonSerializable<NetworkConfigurationDiagnosticResult> {
    private NetworkConfigurationDiagnosticProfile profile;
    private NetworkSecurityGroupResult networkSecurityGroupResult;

    public NetworkConfigurationDiagnosticProfile profile() {
        return this.profile;
    }

    public NetworkConfigurationDiagnosticResult withProfile(NetworkConfigurationDiagnosticProfile profile) {
        this.profile = profile;
        return this;
    }

    public NetworkSecurityGroupResult networkSecurityGroupResult() {
        return this.networkSecurityGroupResult;
    }

    public NetworkConfigurationDiagnosticResult withNetworkSecurityGroupResult(NetworkSecurityGroupResult networkSecurityGroupResult) {
        this.networkSecurityGroupResult = networkSecurityGroupResult;
        return this;
    }

    public void validate() {
        if (this.profile() != null) {
            this.profile().validate();
        }
        if (this.networkSecurityGroupResult() != null) {
            this.networkSecurityGroupResult().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("profile", (JsonSerializable)this.profile);
        jsonWriter.writeJsonField("networkSecurityGroupResult", (JsonSerializable)this.networkSecurityGroupResult);
        return jsonWriter.writeEndObject();
    }

    public static NetworkConfigurationDiagnosticResult fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkConfigurationDiagnosticResult)jsonReader.readObject(reader -> {
            NetworkConfigurationDiagnosticResult deserializedNetworkConfigurationDiagnosticResult = new NetworkConfigurationDiagnosticResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("profile".equals(fieldName)) {
                    deserializedNetworkConfigurationDiagnosticResult.profile = NetworkConfigurationDiagnosticProfile.fromJson(reader);
                    continue;
                }
                if ("networkSecurityGroupResult".equals(fieldName)) {
                    deserializedNetworkConfigurationDiagnosticResult.networkSecurityGroupResult = NetworkSecurityGroupResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkConfigurationDiagnosticResult;
        });
    }
}

