/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ManagedRuleGroupOverride;
import java.io.IOException;
import java.util.List;

public final class ManagedRuleSet
implements JsonSerializable<ManagedRuleSet> {
    private String ruleSetType;
    private String ruleSetVersion;
    private List<ManagedRuleGroupOverride> ruleGroupOverrides;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedRuleSet.class);

    public String ruleSetType() {
        return this.ruleSetType;
    }

    public ManagedRuleSet withRuleSetType(String ruleSetType) {
        this.ruleSetType = ruleSetType;
        return this;
    }

    public String ruleSetVersion() {
        return this.ruleSetVersion;
    }

    public ManagedRuleSet withRuleSetVersion(String ruleSetVersion) {
        this.ruleSetVersion = ruleSetVersion;
        return this;
    }

    public List<ManagedRuleGroupOverride> ruleGroupOverrides() {
        return this.ruleGroupOverrides;
    }

    public ManagedRuleSet withRuleGroupOverrides(List<ManagedRuleGroupOverride> ruleGroupOverrides) {
        this.ruleGroupOverrides = ruleGroupOverrides;
        return this;
    }

    public void validate() {
        if (this.ruleSetType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ruleSetType in model ManagedRuleSet"));
        }
        if (this.ruleSetVersion() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ruleSetVersion in model ManagedRuleSet"));
        }
        if (this.ruleGroupOverrides() != null) {
            this.ruleGroupOverrides().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleSetType", this.ruleSetType);
        jsonWriter.writeStringField("ruleSetVersion", this.ruleSetVersion);
        jsonWriter.writeArrayField("ruleGroupOverrides", this.ruleGroupOverrides, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedRuleSet fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedRuleSet)jsonReader.readObject(reader -> {
            ManagedRuleSet deserializedManagedRuleSet = new ManagedRuleSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleSetType".equals(fieldName)) {
                    deserializedManagedRuleSet.ruleSetType = reader.getString();
                    continue;
                }
                if ("ruleSetVersion".equals(fieldName)) {
                    deserializedManagedRuleSet.ruleSetVersion = reader.getString();
                    continue;
                }
                if ("ruleGroupOverrides".equals(fieldName)) {
                    List ruleGroupOverrides;
                    deserializedManagedRuleSet.ruleGroupOverrides = ruleGroupOverrides = reader.readArray(reader1 -> ManagedRuleGroupOverride.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedRuleSet;
        });
    }
}

