/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.PublicIpAddressInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class FrontendIpConfigurationPropertiesFormatInner
implements JsonSerializable<FrontendIpConfigurationPropertiesFormatInner> {
    private List<SubResource> inboundNatRules;
    private List<SubResource> inboundNatPools;
    private List<SubResource> outboundRules;
    private List<SubResource> loadBalancingRules;
    private String privateIpAddress;
    private IpAllocationMethod privateIpAllocationMethod;
    private IpVersion privateIpAddressVersion;
    private SubnetInner subnet;
    private PublicIpAddressInner publicIpAddress;
    private SubResource publicIpPrefix;
    private SubResource gatewayLoadBalancer;
    private ProvisioningState provisioningState;

    public List<SubResource> inboundNatRules() {
        return this.inboundNatRules;
    }

    public List<SubResource> inboundNatPools() {
        return this.inboundNatPools;
    }

    public List<SubResource> outboundRules() {
        return this.outboundRules;
    }

    public List<SubResource> loadBalancingRules() {
        return this.loadBalancingRules;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public FrontendIpConfigurationPropertiesFormatInner withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    public FrontendIpConfigurationPropertiesFormatInner withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    public IpVersion privateIpAddressVersion() {
        return this.privateIpAddressVersion;
    }

    public FrontendIpConfigurationPropertiesFormatInner withPrivateIpAddressVersion(IpVersion privateIpAddressVersion) {
        this.privateIpAddressVersion = privateIpAddressVersion;
        return this;
    }

    public SubnetInner subnet() {
        return this.subnet;
    }

    public FrontendIpConfigurationPropertiesFormatInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    public PublicIpAddressInner publicIpAddress() {
        return this.publicIpAddress;
    }

    public FrontendIpConfigurationPropertiesFormatInner withPublicIpAddress(PublicIpAddressInner publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    public SubResource publicIpPrefix() {
        return this.publicIpPrefix;
    }

    public FrontendIpConfigurationPropertiesFormatInner withPublicIpPrefix(SubResource publicIpPrefix) {
        this.publicIpPrefix = publicIpPrefix;
        return this;
    }

    public SubResource gatewayLoadBalancer() {
        return this.gatewayLoadBalancer;
    }

    public FrontendIpConfigurationPropertiesFormatInner withGatewayLoadBalancer(SubResource gatewayLoadBalancer) {
        this.gatewayLoadBalancer = gatewayLoadBalancer;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.subnet() != null) {
            this.subnet().validate();
        }
        if (this.publicIpAddress() != null) {
            this.publicIpAddress().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateIPAddress", this.privateIpAddress);
        jsonWriter.writeStringField("privateIPAllocationMethod", this.privateIpAllocationMethod == null ? null : this.privateIpAllocationMethod.toString());
        jsonWriter.writeStringField("privateIPAddressVersion", this.privateIpAddressVersion == null ? null : this.privateIpAddressVersion.toString());
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        jsonWriter.writeJsonField("publicIPAddress", (JsonSerializable)this.publicIpAddress);
        jsonWriter.writeJsonField("publicIPPrefix", (JsonSerializable)this.publicIpPrefix);
        jsonWriter.writeJsonField("gatewayLoadBalancer", (JsonSerializable)this.gatewayLoadBalancer);
        return jsonWriter.writeEndObject();
    }

    public static FrontendIpConfigurationPropertiesFormatInner fromJson(JsonReader jsonReader) throws IOException {
        return (FrontendIpConfigurationPropertiesFormatInner)jsonReader.readObject(reader -> {
            FrontendIpConfigurationPropertiesFormatInner deserializedFrontendIpConfigurationPropertiesFormatInner = new FrontendIpConfigurationPropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inboundNatRules".equals(fieldName)) {
                    List inboundNatRules;
                    deserializedFrontendIpConfigurationPropertiesFormatInner.inboundNatRules = inboundNatRules = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("inboundNatPools".equals(fieldName)) {
                    List inboundNatPools;
                    deserializedFrontendIpConfigurationPropertiesFormatInner.inboundNatPools = inboundNatPools = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("outboundRules".equals(fieldName)) {
                    List outboundRules;
                    deserializedFrontendIpConfigurationPropertiesFormatInner.outboundRules = outboundRules = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("loadBalancingRules".equals(fieldName)) {
                    List loadBalancingRules;
                    deserializedFrontendIpConfigurationPropertiesFormatInner.loadBalancingRules = loadBalancingRules = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("privateIPAddress".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.privateIpAddress = reader.getString();
                    continue;
                }
                if ("privateIPAllocationMethod".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.privateIpAllocationMethod = IpAllocationMethod.fromString(reader.getString());
                    continue;
                }
                if ("privateIPAddressVersion".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.privateIpAddressVersion = IpVersion.fromString(reader.getString());
                    continue;
                }
                if ("subnet".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.subnet = SubnetInner.fromJson(reader);
                    continue;
                }
                if ("publicIPAddress".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.publicIpAddress = PublicIpAddressInner.fromJson(reader);
                    continue;
                }
                if ("publicIPPrefix".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.publicIpPrefix = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("gatewayLoadBalancer".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.gatewayLoadBalancer = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedFrontendIpConfigurationPropertiesFormatInner.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFrontendIpConfigurationPropertiesFormatInner;
        });
    }
}

