/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHealthServerHealth;
import java.io.IOException;

public final class ApplicationGatewayBackendHealthServerInner
implements JsonSerializable<ApplicationGatewayBackendHealthServerInner> {
    private String address;
    private NetworkInterfaceIpConfigurationInner ipConfiguration;
    private ApplicationGatewayBackendHealthServerHealth health;
    private String healthProbeLog;

    public String address() {
        return this.address;
    }

    public ApplicationGatewayBackendHealthServerInner withAddress(String address) {
        this.address = address;
        return this;
    }

    public NetworkInterfaceIpConfigurationInner ipConfiguration() {
        return this.ipConfiguration;
    }

    public ApplicationGatewayBackendHealthServerInner withIpConfiguration(NetworkInterfaceIpConfigurationInner ipConfiguration) {
        this.ipConfiguration = ipConfiguration;
        return this;
    }

    public ApplicationGatewayBackendHealthServerHealth health() {
        return this.health;
    }

    public ApplicationGatewayBackendHealthServerInner withHealth(ApplicationGatewayBackendHealthServerHealth health) {
        this.health = health;
        return this;
    }

    public String healthProbeLog() {
        return this.healthProbeLog;
    }

    public ApplicationGatewayBackendHealthServerInner withHealthProbeLog(String healthProbeLog) {
        this.healthProbeLog = healthProbeLog;
        return this;
    }

    public void validate() {
        if (this.ipConfiguration() != null) {
            this.ipConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("address", this.address);
        jsonWriter.writeJsonField("ipConfiguration", (JsonSerializable)this.ipConfiguration);
        jsonWriter.writeStringField("health", this.health == null ? null : this.health.toString());
        jsonWriter.writeStringField("healthProbeLog", this.healthProbeLog);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayBackendHealthServerInner fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayBackendHealthServerInner)jsonReader.readObject(reader -> {
            ApplicationGatewayBackendHealthServerInner deserializedApplicationGatewayBackendHealthServerInner = new ApplicationGatewayBackendHealthServerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("address".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHealthServerInner.address = reader.getString();
                    continue;
                }
                if ("ipConfiguration".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHealthServerInner.ipConfiguration = NetworkInterfaceIpConfigurationInner.fromJson(reader);
                    continue;
                }
                if ("health".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHealthServerInner.health = ApplicationGatewayBackendHealthServerHealth.fromString(reader.getString());
                    continue;
                }
                if ("healthProbeLog".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHealthServerInner.healthProbeLog = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayBackendHealthServerInner;
        });
    }
}

