// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkUsageInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for the virtual networks GetUsage API service call.
 */
@Fluent
public final class VirtualNetworkListUsageResult implements JsonSerializable<VirtualNetworkListUsageResult> {
    /*
     * VirtualNetwork usage stats.
     */
    private List<VirtualNetworkUsageInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of VirtualNetworkListUsageResult class.
     */
    public VirtualNetworkListUsageResult() {
    }

    /**
     * Get the value property: VirtualNetwork usage stats.
     * 
     * @return the value value.
     */
    public List<VirtualNetworkUsageInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the VirtualNetworkListUsageResult object itself.
     */
    public VirtualNetworkListUsageResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkListUsageResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkListUsageResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkListUsageResult.
     */
    public static VirtualNetworkListUsageResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkListUsageResult deserializedVirtualNetworkListUsageResult
                = new VirtualNetworkListUsageResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualNetworkUsageInner> value
                        = reader.readArray(reader1 -> VirtualNetworkUsageInner.fromJson(reader1));
                    deserializedVirtualNetworkListUsageResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedVirtualNetworkListUsageResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkListUsageResult;
        });
    }
}
