// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Network Group member type.
 */
public final class GroupMemberType extends ExpandableStringEnum<GroupMemberType> {
    /**
     * Static value VirtualNetwork for GroupMemberType.
     */
    public static final GroupMemberType VIRTUAL_NETWORK = fromString("VirtualNetwork");

    /**
     * Static value Subnet for GroupMemberType.
     */
    public static final GroupMemberType SUBNET = fromString("Subnet");

    /**
     * Creates a new instance of GroupMemberType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public GroupMemberType() {
    }

    /**
     * Creates or finds a GroupMemberType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding GroupMemberType.
     */
    public static GroupMemberType fromString(String name) {
        return fromString(name, GroupMemberType.class);
    }

    /**
     * Gets known GroupMemberType values.
     * 
     * @return known GroupMemberType values.
     */
    public static Collection<GroupMemberType> values() {
        return values(GroupMemberType.class);
    }
}
