// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.TopologyResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Topology of the specified resource group.
 */
@Fluent
public final class TopologyInner implements JsonSerializable<TopologyInner> {
    /*
     * GUID representing the operation id.
     */
    private String id;

    /*
     * The datetime when the topology was initially created for the resource group.
     */
    private OffsetDateTime createdDateTime;

    /*
     * The datetime when the topology was last modified.
     */
    private OffsetDateTime lastModified;

    /*
     * A list of topology resources.
     */
    private List<TopologyResource> resources;

    /**
     * Creates an instance of TopologyInner class.
     */
    public TopologyInner() {
    }

    /**
     * Get the id property: GUID representing the operation id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the createdDateTime property: The datetime when the topology was initially created for the resource group.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Get the lastModified property: The datetime when the topology was last modified.
     * 
     * @return the lastModified value.
     */
    public OffsetDateTime lastModified() {
        return this.lastModified;
    }

    /**
     * Get the resources property: A list of topology resources.
     * 
     * @return the resources value.
     */
    public List<TopologyResource> resources() {
        return this.resources;
    }

    /**
     * Set the resources property: A list of topology resources.
     * 
     * @param resources the resources value to set.
     * @return the TopologyInner object itself.
     */
    public TopologyInner withResources(List<TopologyResource> resources) {
        this.resources = resources;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resources() != null) {
            resources().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("resources", this.resources, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TopologyInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TopologyInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TopologyInner.
     */
    public static TopologyInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TopologyInner deserializedTopologyInner = new TopologyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTopologyInner.id = reader.getString();
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedTopologyInner.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastModified".equals(fieldName)) {
                    deserializedTopologyInner.lastModified = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("resources".equals(fieldName)) {
                    List<TopologyResource> resources = reader.readArray(reader1 -> TopologyResource.fromJson(reader1));
                    deserializedTopologyInner.resources = resources;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTopologyInner;
        });
    }
}
