/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.P2SConnectionConfigurationProperties;
import com.azure.resourcemanager.network.fluent.models.VpnServerConfigurationPolicyGroupInner;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingConfiguration;
import java.io.IOException;
import java.util.List;

public final class P2SConnectionConfiguration
extends SubResource {
    private P2SConnectionConfigurationProperties innerProperties;
    private String name;
    private String etag;

    private P2SConnectionConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public P2SConnectionConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public P2SConnectionConfiguration withId(String id) {
        super.withId(id);
        return this;
    }

    public AddressSpace vpnClientAddressPool() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnClientAddressPool();
    }

    public P2SConnectionConfiguration withVpnClientAddressPool(AddressSpace vpnClientAddressPool) {
        if (this.innerProperties() == null) {
            this.innerProperties = new P2SConnectionConfigurationProperties();
        }
        this.innerProperties().withVpnClientAddressPool(vpnClientAddressPool);
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().routingConfiguration();
    }

    public P2SConnectionConfiguration withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new P2SConnectionConfigurationProperties();
        }
        this.innerProperties().withRoutingConfiguration(routingConfiguration);
        return this;
    }

    public Boolean enableInternetSecurity() {
        return this.innerProperties() == null ? null : this.innerProperties().enableInternetSecurity();
    }

    public P2SConnectionConfiguration withEnableInternetSecurity(Boolean enableInternetSecurity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new P2SConnectionConfigurationProperties();
        }
        this.innerProperties().withEnableInternetSecurity(enableInternetSecurity);
        return this;
    }

    public List<SubResource> configurationPolicyGroupAssociations() {
        return this.innerProperties() == null ? null : this.innerProperties().configurationPolicyGroupAssociations();
    }

    public List<VpnServerConfigurationPolicyGroupInner> previousConfigurationPolicyGroupAssociations() {
        return this.innerProperties() == null ? null : this.innerProperties().previousConfigurationPolicyGroupAssociations();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static P2SConnectionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (P2SConnectionConfiguration)((Object)jsonReader.readObject(reader -> {
            P2SConnectionConfiguration deserializedP2SConnectionConfiguration = new P2SConnectionConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedP2SConnectionConfiguration.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedP2SConnectionConfiguration.innerProperties = P2SConnectionConfigurationProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedP2SConnectionConfiguration.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedP2SConnectionConfiguration.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedP2SConnectionConfiguration;
        }));
    }
}

