// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Type of Actions.
 */
public final class WebApplicationFirewallAction extends ExpandableStringEnum<WebApplicationFirewallAction> {
    /**
     * Static value Allow for WebApplicationFirewallAction.
     */
    public static final WebApplicationFirewallAction ALLOW = fromString("Allow");

    /**
     * Static value Block for WebApplicationFirewallAction.
     */
    public static final WebApplicationFirewallAction BLOCK = fromString("Block");

    /**
     * Static value Log for WebApplicationFirewallAction.
     */
    public static final WebApplicationFirewallAction LOG = fromString("Log");

    /**
     * Static value JSChallenge for WebApplicationFirewallAction.
     */
    public static final WebApplicationFirewallAction JSCHALLENGE = fromString("JSChallenge");

    /**
     * Creates a new instance of WebApplicationFirewallAction value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public WebApplicationFirewallAction() {
    }

    /**
     * Creates or finds a WebApplicationFirewallAction from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding WebApplicationFirewallAction.
     */
    public static WebApplicationFirewallAction fromString(String name) {
        return fromString(name, WebApplicationFirewallAction.class);
    }

    /**
     * Gets known WebApplicationFirewallAction values.
     * 
     * @return known WebApplicationFirewallAction values.
     */
    public static Collection<WebApplicationFirewallAction> values() {
        return values(WebApplicationFirewallAction.class);
    }
}
