// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConnectivityGroupItem;
import com.azure.resourcemanager.network.models.ConnectivityTopology;
import com.azure.resourcemanager.network.models.DeleteExistingPeering;
import com.azure.resourcemanager.network.models.Hub;
import com.azure.resourcemanager.network.models.IsGlobal;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of network manager connectivity configuration.
 */
@Fluent
public final class ConnectivityConfigurationProperties
    implements JsonSerializable<ConnectivityConfigurationProperties> {
    /*
     * A description of the connectivity configuration.
     */
    private String description;

    /*
     * Connectivity topology type.
     */
    private ConnectivityTopology connectivityTopology;

    /*
     * List of hubItems
     */
    private List<Hub> hubs;

    /*
     * Flag if global mesh is supported.
     */
    private IsGlobal isGlobal;

    /*
     * Groups for configuration
     */
    private List<ConnectivityGroupItem> appliesToGroups;

    /*
     * The provisioning state of the connectivity configuration resource.
     */
    private ProvisioningState provisioningState;

    /*
     * Flag if need to remove current existing peerings.
     */
    private DeleteExistingPeering deleteExistingPeering;

    /*
     * Unique identifier for this resource.
     */
    private String resourceGuid;

    /**
     * Creates an instance of ConnectivityConfigurationProperties class.
     */
    public ConnectivityConfigurationProperties() {
    }

    /**
     * Get the description property: A description of the connectivity configuration.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description of the connectivity configuration.
     * 
     * @param description the description value to set.
     * @return the ConnectivityConfigurationProperties object itself.
     */
    public ConnectivityConfigurationProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the connectivityTopology property: Connectivity topology type.
     * 
     * @return the connectivityTopology value.
     */
    public ConnectivityTopology connectivityTopology() {
        return this.connectivityTopology;
    }

    /**
     * Set the connectivityTopology property: Connectivity topology type.
     * 
     * @param connectivityTopology the connectivityTopology value to set.
     * @return the ConnectivityConfigurationProperties object itself.
     */
    public ConnectivityConfigurationProperties withConnectivityTopology(ConnectivityTopology connectivityTopology) {
        this.connectivityTopology = connectivityTopology;
        return this;
    }

    /**
     * Get the hubs property: List of hubItems.
     * 
     * @return the hubs value.
     */
    public List<Hub> hubs() {
        return this.hubs;
    }

    /**
     * Set the hubs property: List of hubItems.
     * 
     * @param hubs the hubs value to set.
     * @return the ConnectivityConfigurationProperties object itself.
     */
    public ConnectivityConfigurationProperties withHubs(List<Hub> hubs) {
        this.hubs = hubs;
        return this;
    }

    /**
     * Get the isGlobal property: Flag if global mesh is supported.
     * 
     * @return the isGlobal value.
     */
    public IsGlobal isGlobal() {
        return this.isGlobal;
    }

    /**
     * Set the isGlobal property: Flag if global mesh is supported.
     * 
     * @param isGlobal the isGlobal value to set.
     * @return the ConnectivityConfigurationProperties object itself.
     */
    public ConnectivityConfigurationProperties withIsGlobal(IsGlobal isGlobal) {
        this.isGlobal = isGlobal;
        return this;
    }

    /**
     * Get the appliesToGroups property: Groups for configuration.
     * 
     * @return the appliesToGroups value.
     */
    public List<ConnectivityGroupItem> appliesToGroups() {
        return this.appliesToGroups;
    }

    /**
     * Set the appliesToGroups property: Groups for configuration.
     * 
     * @param appliesToGroups the appliesToGroups value to set.
     * @return the ConnectivityConfigurationProperties object itself.
     */
    public ConnectivityConfigurationProperties withAppliesToGroups(List<ConnectivityGroupItem> appliesToGroups) {
        this.appliesToGroups = appliesToGroups;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the connectivity configuration resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the deleteExistingPeering property: Flag if need to remove current existing peerings.
     * 
     * @return the deleteExistingPeering value.
     */
    public DeleteExistingPeering deleteExistingPeering() {
        return this.deleteExistingPeering;
    }

    /**
     * Set the deleteExistingPeering property: Flag if need to remove current existing peerings.
     * 
     * @param deleteExistingPeering the deleteExistingPeering value to set.
     * @return the ConnectivityConfigurationProperties object itself.
     */
    public ConnectivityConfigurationProperties withDeleteExistingPeering(DeleteExistingPeering deleteExistingPeering) {
        this.deleteExistingPeering = deleteExistingPeering;
        return this;
    }

    /**
     * Get the resourceGuid property: Unique identifier for this resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (connectivityTopology() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property connectivityTopology in model ConnectivityConfigurationProperties"));
        }
        if (hubs() != null) {
            hubs().forEach(e -> e.validate());
        }
        if (appliesToGroups() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property appliesToGroups in model ConnectivityConfigurationProperties"));
        } else {
            appliesToGroups().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityConfigurationProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectivityTopology",
            this.connectivityTopology == null ? null : this.connectivityTopology.toString());
        jsonWriter.writeArrayField("appliesToGroups", this.appliesToGroups,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("hubs", this.hubs, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("isGlobal", this.isGlobal == null ? null : this.isGlobal.toString());
        jsonWriter.writeStringField("deleteExistingPeering",
            this.deleteExistingPeering == null ? null : this.deleteExistingPeering.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectivityConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectivityConfigurationProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectivityConfigurationProperties.
     */
    public static ConnectivityConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectivityConfigurationProperties deserializedConnectivityConfigurationProperties
                = new ConnectivityConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("connectivityTopology".equals(fieldName)) {
                    deserializedConnectivityConfigurationProperties.connectivityTopology
                        = ConnectivityTopology.fromString(reader.getString());
                } else if ("appliesToGroups".equals(fieldName)) {
                    List<ConnectivityGroupItem> appliesToGroups
                        = reader.readArray(reader1 -> ConnectivityGroupItem.fromJson(reader1));
                    deserializedConnectivityConfigurationProperties.appliesToGroups = appliesToGroups;
                } else if ("description".equals(fieldName)) {
                    deserializedConnectivityConfigurationProperties.description = reader.getString();
                } else if ("hubs".equals(fieldName)) {
                    List<Hub> hubs = reader.readArray(reader1 -> Hub.fromJson(reader1));
                    deserializedConnectivityConfigurationProperties.hubs = hubs;
                } else if ("isGlobal".equals(fieldName)) {
                    deserializedConnectivityConfigurationProperties.isGlobal = IsGlobal.fromString(reader.getString());
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedConnectivityConfigurationProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("deleteExistingPeering".equals(fieldName)) {
                    deserializedConnectivityConfigurationProperties.deleteExistingPeering
                        = DeleteExistingPeering.fromString(reader.getString());
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedConnectivityConfigurationProperties.resourceGuid = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectivityConfigurationProperties;
        });
    }
}
