// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.SecurityRuleInner;
import java.io.IOException;
import java.util.List;

/**
 * All security rules associated with the network interface.
 */
@Fluent
public final class SecurityRuleAssociations implements JsonSerializable<SecurityRuleAssociations> {
    /*
     * Network interface and it's custom security rules.
     */
    private NetworkInterfaceAssociation networkInterfaceAssociation;

    /*
     * Subnet and it's custom security rules.
     */
    private SubnetAssociation subnetAssociation;

    /*
     * Collection of default security rules of the network security group.
     */
    private List<SecurityRuleInner> defaultSecurityRules;

    /*
     * Collection of effective security rules.
     */
    private List<EffectiveNetworkSecurityRule> effectiveSecurityRules;

    /**
     * Creates an instance of SecurityRuleAssociations class.
     */
    public SecurityRuleAssociations() {
    }

    /**
     * Get the networkInterfaceAssociation property: Network interface and it's custom security rules.
     * 
     * @return the networkInterfaceAssociation value.
     */
    public NetworkInterfaceAssociation networkInterfaceAssociation() {
        return this.networkInterfaceAssociation;
    }

    /**
     * Set the networkInterfaceAssociation property: Network interface and it's custom security rules.
     * 
     * @param networkInterfaceAssociation the networkInterfaceAssociation value to set.
     * @return the SecurityRuleAssociations object itself.
     */
    public SecurityRuleAssociations
        withNetworkInterfaceAssociation(NetworkInterfaceAssociation networkInterfaceAssociation) {
        this.networkInterfaceAssociation = networkInterfaceAssociation;
        return this;
    }

    /**
     * Get the subnetAssociation property: Subnet and it's custom security rules.
     * 
     * @return the subnetAssociation value.
     */
    public SubnetAssociation subnetAssociation() {
        return this.subnetAssociation;
    }

    /**
     * Set the subnetAssociation property: Subnet and it's custom security rules.
     * 
     * @param subnetAssociation the subnetAssociation value to set.
     * @return the SecurityRuleAssociations object itself.
     */
    public SecurityRuleAssociations withSubnetAssociation(SubnetAssociation subnetAssociation) {
        this.subnetAssociation = subnetAssociation;
        return this;
    }

    /**
     * Get the defaultSecurityRules property: Collection of default security rules of the network security group.
     * 
     * @return the defaultSecurityRules value.
     */
    public List<SecurityRuleInner> defaultSecurityRules() {
        return this.defaultSecurityRules;
    }

    /**
     * Set the defaultSecurityRules property: Collection of default security rules of the network security group.
     * 
     * @param defaultSecurityRules the defaultSecurityRules value to set.
     * @return the SecurityRuleAssociations object itself.
     */
    public SecurityRuleAssociations withDefaultSecurityRules(List<SecurityRuleInner> defaultSecurityRules) {
        this.defaultSecurityRules = defaultSecurityRules;
        return this;
    }

    /**
     * Get the effectiveSecurityRules property: Collection of effective security rules.
     * 
     * @return the effectiveSecurityRules value.
     */
    public List<EffectiveNetworkSecurityRule> effectiveSecurityRules() {
        return this.effectiveSecurityRules;
    }

    /**
     * Set the effectiveSecurityRules property: Collection of effective security rules.
     * 
     * @param effectiveSecurityRules the effectiveSecurityRules value to set.
     * @return the SecurityRuleAssociations object itself.
     */
    public SecurityRuleAssociations
        withEffectiveSecurityRules(List<EffectiveNetworkSecurityRule> effectiveSecurityRules) {
        this.effectiveSecurityRules = effectiveSecurityRules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkInterfaceAssociation() != null) {
            networkInterfaceAssociation().validate();
        }
        if (subnetAssociation() != null) {
            subnetAssociation().validate();
        }
        if (defaultSecurityRules() != null) {
            defaultSecurityRules().forEach(e -> e.validate());
        }
        if (effectiveSecurityRules() != null) {
            effectiveSecurityRules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("networkInterfaceAssociation", this.networkInterfaceAssociation);
        jsonWriter.writeJsonField("subnetAssociation", this.subnetAssociation);
        jsonWriter.writeArrayField("defaultSecurityRules", this.defaultSecurityRules,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("effectiveSecurityRules", this.effectiveSecurityRules,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityRuleAssociations from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityRuleAssociations if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityRuleAssociations.
     */
    public static SecurityRuleAssociations fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityRuleAssociations deserializedSecurityRuleAssociations = new SecurityRuleAssociations();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("networkInterfaceAssociation".equals(fieldName)) {
                    deserializedSecurityRuleAssociations.networkInterfaceAssociation
                        = NetworkInterfaceAssociation.fromJson(reader);
                } else if ("subnetAssociation".equals(fieldName)) {
                    deserializedSecurityRuleAssociations.subnetAssociation = SubnetAssociation.fromJson(reader);
                } else if ("defaultSecurityRules".equals(fieldName)) {
                    List<SecurityRuleInner> defaultSecurityRules
                        = reader.readArray(reader1 -> SecurityRuleInner.fromJson(reader1));
                    deserializedSecurityRuleAssociations.defaultSecurityRules = defaultSecurityRules;
                } else if ("effectiveSecurityRules".equals(fieldName)) {
                    List<EffectiveNetworkSecurityRule> effectiveSecurityRules
                        = reader.readArray(reader1 -> EffectiveNetworkSecurityRule.fromJson(reader1));
                    deserializedSecurityRuleAssociations.effectiveSecurityRules = effectiveSecurityRules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityRuleAssociations;
        });
    }
}
