// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Define match conditions.
 */
@Fluent
public final class MatchCondition implements JsonSerializable<MatchCondition> {
    /*
     * List of match variables.
     */
    private List<MatchVariable> matchVariables;

    /*
     * The operator to be matched.
     */
    private WebApplicationFirewallOperator operator;

    /*
     * Whether this is negate condition or not.
     */
    private Boolean negationConditon;

    /*
     * Match value.
     */
    private List<String> matchValues;

    /*
     * List of transforms.
     */
    private List<WebApplicationFirewallTransform> transforms;

    /**
     * Creates an instance of MatchCondition class.
     */
    public MatchCondition() {
    }

    /**
     * Get the matchVariables property: List of match variables.
     * 
     * @return the matchVariables value.
     */
    public List<MatchVariable> matchVariables() {
        return this.matchVariables;
    }

    /**
     * Set the matchVariables property: List of match variables.
     * 
     * @param matchVariables the matchVariables value to set.
     * @return the MatchCondition object itself.
     */
    public MatchCondition withMatchVariables(List<MatchVariable> matchVariables) {
        this.matchVariables = matchVariables;
        return this;
    }

    /**
     * Get the operator property: The operator to be matched.
     * 
     * @return the operator value.
     */
    public WebApplicationFirewallOperator operator() {
        return this.operator;
    }

    /**
     * Set the operator property: The operator to be matched.
     * 
     * @param operator the operator value to set.
     * @return the MatchCondition object itself.
     */
    public MatchCondition withOperator(WebApplicationFirewallOperator operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the negationConditon property: Whether this is negate condition or not.
     * 
     * @return the negationConditon value.
     */
    public Boolean negationConditon() {
        return this.negationConditon;
    }

    /**
     * Set the negationConditon property: Whether this is negate condition or not.
     * 
     * @param negationConditon the negationConditon value to set.
     * @return the MatchCondition object itself.
     */
    public MatchCondition withNegationConditon(Boolean negationConditon) {
        this.negationConditon = negationConditon;
        return this;
    }

    /**
     * Get the matchValues property: Match value.
     * 
     * @return the matchValues value.
     */
    public List<String> matchValues() {
        return this.matchValues;
    }

    /**
     * Set the matchValues property: Match value.
     * 
     * @param matchValues the matchValues value to set.
     * @return the MatchCondition object itself.
     */
    public MatchCondition withMatchValues(List<String> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    /**
     * Get the transforms property: List of transforms.
     * 
     * @return the transforms value.
     */
    public List<WebApplicationFirewallTransform> transforms() {
        return this.transforms;
    }

    /**
     * Set the transforms property: List of transforms.
     * 
     * @param transforms the transforms value to set.
     * @return the MatchCondition object itself.
     */
    public MatchCondition withTransforms(List<WebApplicationFirewallTransform> transforms) {
        this.transforms = transforms;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (matchVariables() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property matchVariables in model MatchCondition"));
        } else {
            matchVariables().forEach(e -> e.validate());
        }
        if (operator() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property operator in model MatchCondition"));
        }
        if (matchValues() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property matchValues in model MatchCondition"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MatchCondition.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("matchVariables", this.matchVariables,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeArrayField("matchValues", this.matchValues, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("negationConditon", this.negationConditon);
        jsonWriter.writeArrayField("transforms", this.transforms,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MatchCondition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MatchCondition if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MatchCondition.
     */
    public static MatchCondition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MatchCondition deserializedMatchCondition = new MatchCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("matchVariables".equals(fieldName)) {
                    List<MatchVariable> matchVariables = reader.readArray(reader1 -> MatchVariable.fromJson(reader1));
                    deserializedMatchCondition.matchVariables = matchVariables;
                } else if ("operator".equals(fieldName)) {
                    deserializedMatchCondition.operator = WebApplicationFirewallOperator.fromString(reader.getString());
                } else if ("matchValues".equals(fieldName)) {
                    List<String> matchValues = reader.readArray(reader1 -> reader1.getString());
                    deserializedMatchCondition.matchValues = matchValues;
                } else if ("negationConditon".equals(fieldName)) {
                    deserializedMatchCondition.negationConditon = reader.getNullable(JsonReader::getBoolean);
                } else if ("transforms".equals(fieldName)) {
                    List<WebApplicationFirewallTransform> transforms
                        = reader.readArray(reader1 -> WebApplicationFirewallTransform.fromString(reader1.getString()));
                    deserializedMatchCondition.transforms = transforms;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMatchCondition;
        });
    }
}
