// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Encapsulation method on physical ports.
 */
public final class ExpressRoutePortsEncapsulation extends ExpandableStringEnum<ExpressRoutePortsEncapsulation> {
    /**
     * Static value Dot1Q for ExpressRoutePortsEncapsulation.
     */
    public static final ExpressRoutePortsEncapsulation DOT1Q = fromString("Dot1Q");

    /**
     * Static value QinQ for ExpressRoutePortsEncapsulation.
     */
    public static final ExpressRoutePortsEncapsulation QINQ = fromString("QinQ");

    /**
     * Creates a new instance of ExpressRoutePortsEncapsulation value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ExpressRoutePortsEncapsulation() {
    }

    /**
     * Creates or finds a ExpressRoutePortsEncapsulation from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ExpressRoutePortsEncapsulation.
     */
    public static ExpressRoutePortsEncapsulation fromString(String name) {
        return fromString(name, ExpressRoutePortsEncapsulation.class);
    }

    /**
     * Gets known ExpressRoutePortsEncapsulation values.
     * 
     * @return known ExpressRoutePortsEncapsulation values.
     */
    public static Collection<ExpressRoutePortsEncapsulation> values() {
        return values(ExpressRoutePortsEncapsulation.class);
    }
}
