// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.
 */
@Fluent
public final class AddressSpace implements JsonSerializable<AddressSpace> {
    /*
     * A list of address blocks reserved for this virtual network in CIDR notation.
     */
    private List<String> addressPrefixes;

    /**
     * Creates an instance of AddressSpace class.
     */
    public AddressSpace() {
    }

    /**
     * Get the addressPrefixes property: A list of address blocks reserved for this virtual network in CIDR notation.
     * 
     * @return the addressPrefixes value.
     */
    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    /**
     * Set the addressPrefixes property: A list of address blocks reserved for this virtual network in CIDR notation.
     * 
     * @param addressPrefixes the addressPrefixes value to set.
     * @return the AddressSpace object itself.
     */
    public AddressSpace withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AddressSpace from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AddressSpace if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AddressSpace.
     */
    public static AddressSpace fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AddressSpace deserializedAddressSpace = new AddressSpace();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("addressPrefixes".equals(fieldName)) {
                    List<String> addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedAddressSpace.addressPrefixes = addressPrefixes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAddressSpace;
        });
    }
}
