// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.GatewayCustomBgpIpAddressIpConfiguration;
import com.azure.resourcemanager.network.models.IpsecPolicy;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionProtocol;
import com.azure.resourcemanager.network.models.VpnConnectionStatus;
import com.azure.resourcemanager.network.models.VpnLinkConnectionMode;
import java.io.IOException;
import java.util.List;

/**
 * Parameters for VpnConnection.
 */
@Fluent
public final class VpnSiteLinkConnectionProperties implements JsonSerializable<VpnSiteLinkConnectionProperties> {
    /*
     * Id of the connected vpn site link.
     */
    private SubResource vpnSiteLink;

    /*
     * Routing weight for vpn connection.
     */
    private Integer routingWeight;

    /*
     * Vpn link connection mode.
     */
    private VpnLinkConnectionMode vpnLinkConnectionMode;

    /*
     * The connection status.
     */
    private VpnConnectionStatus connectionStatus;

    /*
     * Connection protocol used for this connection.
     */
    private VirtualNetworkGatewayConnectionProtocol vpnConnectionProtocolType;

    /*
     * Ingress bytes transferred.
     */
    private Long ingressBytesTransferred;

    /*
     * Egress bytes transferred.
     */
    private Long egressBytesTransferred;

    /*
     * Expected bandwidth in MBPS.
     */
    private Integer connectionBandwidth;

    /*
     * SharedKey for the vpn connection.
     */
    private String sharedKey;

    /*
     * EnableBgp flag.
     */
    private Boolean enableBgp;

    /*
     * vpnGatewayCustomBgpAddresses used by this connection.
     */
    private List<GatewayCustomBgpIpAddressIpConfiguration> vpnGatewayCustomBgpAddresses;

    /*
     * Enable policy-based traffic selectors.
     */
    private Boolean usePolicyBasedTrafficSelectors;

    /*
     * The IPSec Policies to be considered by this connection.
     */
    private List<IpsecPolicy> ipsecPolicies;

    /*
     * EnableBgp flag.
     */
    private Boolean enableRateLimiting;

    /*
     * Use local azure ip to initiate connection.
     */
    private Boolean useLocalAzureIpAddress;

    /*
     * The provisioning state of the VPN site link connection resource.
     */
    private ProvisioningState provisioningState;

    /*
     * List of ingress NatRules.
     */
    private List<SubResource> ingressNatRules;

    /*
     * List of egress NatRules.
     */
    private List<SubResource> egressNatRules;

    /*
     * Dead Peer Detection timeout in seconds for VpnLink connection.
     */
    private Integer dpdTimeoutSeconds;

    /**
     * Creates an instance of VpnSiteLinkConnectionProperties class.
     */
    public VpnSiteLinkConnectionProperties() {
    }

    /**
     * Get the vpnSiteLink property: Id of the connected vpn site link.
     * 
     * @return the vpnSiteLink value.
     */
    public SubResource vpnSiteLink() {
        return this.vpnSiteLink;
    }

    /**
     * Set the vpnSiteLink property: Id of the connected vpn site link.
     * 
     * @param vpnSiteLink the vpnSiteLink value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties withVpnSiteLink(SubResource vpnSiteLink) {
        this.vpnSiteLink = vpnSiteLink;
        return this;
    }

    /**
     * Get the routingWeight property: Routing weight for vpn connection.
     * 
     * @return the routingWeight value.
     */
    public Integer routingWeight() {
        return this.routingWeight;
    }

    /**
     * Set the routingWeight property: Routing weight for vpn connection.
     * 
     * @param routingWeight the routingWeight value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties withRoutingWeight(Integer routingWeight) {
        this.routingWeight = routingWeight;
        return this;
    }

    /**
     * Get the vpnLinkConnectionMode property: Vpn link connection mode.
     * 
     * @return the vpnLinkConnectionMode value.
     */
    public VpnLinkConnectionMode vpnLinkConnectionMode() {
        return this.vpnLinkConnectionMode;
    }

    /**
     * Set the vpnLinkConnectionMode property: Vpn link connection mode.
     * 
     * @param vpnLinkConnectionMode the vpnLinkConnectionMode value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties withVpnLinkConnectionMode(VpnLinkConnectionMode vpnLinkConnectionMode) {
        this.vpnLinkConnectionMode = vpnLinkConnectionMode;
        return this;
    }

    /**
     * Get the connectionStatus property: The connection status.
     * 
     * @return the connectionStatus value.
     */
    public VpnConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    /**
     * Get the vpnConnectionProtocolType property: Connection protocol used for this connection.
     * 
     * @return the vpnConnectionProtocolType value.
     */
    public VirtualNetworkGatewayConnectionProtocol vpnConnectionProtocolType() {
        return this.vpnConnectionProtocolType;
    }

    /**
     * Set the vpnConnectionProtocolType property: Connection protocol used for this connection.
     * 
     * @param vpnConnectionProtocolType the vpnConnectionProtocolType value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties
        withVpnConnectionProtocolType(VirtualNetworkGatewayConnectionProtocol vpnConnectionProtocolType) {
        this.vpnConnectionProtocolType = vpnConnectionProtocolType;
        return this;
    }

    /**
     * Get the ingressBytesTransferred property: Ingress bytes transferred.
     * 
     * @return the ingressBytesTransferred value.
     */
    public Long ingressBytesTransferred() {
        return this.ingressBytesTransferred;
    }

    /**
     * Get the egressBytesTransferred property: Egress bytes transferred.
     * 
     * @return the egressBytesTransferred value.
     */
    public Long egressBytesTransferred() {
        return this.egressBytesTransferred;
    }

    /**
     * Get the connectionBandwidth property: Expected bandwidth in MBPS.
     * 
     * @return the connectionBandwidth value.
     */
    public Integer connectionBandwidth() {
        return this.connectionBandwidth;
    }

    /**
     * Set the connectionBandwidth property: Expected bandwidth in MBPS.
     * 
     * @param connectionBandwidth the connectionBandwidth value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties withConnectionBandwidth(Integer connectionBandwidth) {
        this.connectionBandwidth = connectionBandwidth;
        return this;
    }

    /**
     * Get the sharedKey property: SharedKey for the vpn connection.
     * 
     * @return the sharedKey value.
     */
    public String sharedKey() {
        return this.sharedKey;
    }

    /**
     * Set the sharedKey property: SharedKey for the vpn connection.
     * 
     * @param sharedKey the sharedKey value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties withSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
        return this;
    }

    /**
     * Get the enableBgp property: EnableBgp flag.
     * 
     * @return the enableBgp value.
     */
    public Boolean enableBgp() {
        return this.enableBgp;
    }

    /**
     * Set the enableBgp property: EnableBgp flag.
     * 
     * @param enableBgp the enableBgp value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties withEnableBgp(Boolean enableBgp) {
        this.enableBgp = enableBgp;
        return this;
    }

    /**
     * Get the vpnGatewayCustomBgpAddresses property: vpnGatewayCustomBgpAddresses used by this connection.
     * 
     * @return the vpnGatewayCustomBgpAddresses value.
     */
    public List<GatewayCustomBgpIpAddressIpConfiguration> vpnGatewayCustomBgpAddresses() {
        return this.vpnGatewayCustomBgpAddresses;
    }

    /**
     * Set the vpnGatewayCustomBgpAddresses property: vpnGatewayCustomBgpAddresses used by this connection.
     * 
     * @param vpnGatewayCustomBgpAddresses the vpnGatewayCustomBgpAddresses value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties
        withVpnGatewayCustomBgpAddresses(List<GatewayCustomBgpIpAddressIpConfiguration> vpnGatewayCustomBgpAddresses) {
        this.vpnGatewayCustomBgpAddresses = vpnGatewayCustomBgpAddresses;
        return this;
    }

    /**
     * Get the usePolicyBasedTrafficSelectors property: Enable policy-based traffic selectors.
     * 
     * @return the usePolicyBasedTrafficSelectors value.
     */
    public Boolean usePolicyBasedTrafficSelectors() {
        return this.usePolicyBasedTrafficSelectors;
    }

    /**
     * Set the usePolicyBasedTrafficSelectors property: Enable policy-based traffic selectors.
     * 
     * @param usePolicyBasedTrafficSelectors the usePolicyBasedTrafficSelectors value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties withUsePolicyBasedTrafficSelectors(Boolean usePolicyBasedTrafficSelectors) {
        this.usePolicyBasedTrafficSelectors = usePolicyBasedTrafficSelectors;
        return this;
    }

    /**
     * Get the ipsecPolicies property: The IPSec Policies to be considered by this connection.
     * 
     * @return the ipsecPolicies value.
     */
    public List<IpsecPolicy> ipsecPolicies() {
        return this.ipsecPolicies;
    }

    /**
     * Set the ipsecPolicies property: The IPSec Policies to be considered by this connection.
     * 
     * @param ipsecPolicies the ipsecPolicies value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties withIpsecPolicies(List<IpsecPolicy> ipsecPolicies) {
        this.ipsecPolicies = ipsecPolicies;
        return this;
    }

    /**
     * Get the enableRateLimiting property: EnableBgp flag.
     * 
     * @return the enableRateLimiting value.
     */
    public Boolean enableRateLimiting() {
        return this.enableRateLimiting;
    }

    /**
     * Set the enableRateLimiting property: EnableBgp flag.
     * 
     * @param enableRateLimiting the enableRateLimiting value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties withEnableRateLimiting(Boolean enableRateLimiting) {
        this.enableRateLimiting = enableRateLimiting;
        return this;
    }

    /**
     * Get the useLocalAzureIpAddress property: Use local azure ip to initiate connection.
     * 
     * @return the useLocalAzureIpAddress value.
     */
    public Boolean useLocalAzureIpAddress() {
        return this.useLocalAzureIpAddress;
    }

    /**
     * Set the useLocalAzureIpAddress property: Use local azure ip to initiate connection.
     * 
     * @param useLocalAzureIpAddress the useLocalAzureIpAddress value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties withUseLocalAzureIpAddress(Boolean useLocalAzureIpAddress) {
        this.useLocalAzureIpAddress = useLocalAzureIpAddress;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the VPN site link connection resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the ingressNatRules property: List of ingress NatRules.
     * 
     * @return the ingressNatRules value.
     */
    public List<SubResource> ingressNatRules() {
        return this.ingressNatRules;
    }

    /**
     * Set the ingressNatRules property: List of ingress NatRules.
     * 
     * @param ingressNatRules the ingressNatRules value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties withIngressNatRules(List<SubResource> ingressNatRules) {
        this.ingressNatRules = ingressNatRules;
        return this;
    }

    /**
     * Get the egressNatRules property: List of egress NatRules.
     * 
     * @return the egressNatRules value.
     */
    public List<SubResource> egressNatRules() {
        return this.egressNatRules;
    }

    /**
     * Set the egressNatRules property: List of egress NatRules.
     * 
     * @param egressNatRules the egressNatRules value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties withEgressNatRules(List<SubResource> egressNatRules) {
        this.egressNatRules = egressNatRules;
        return this;
    }

    /**
     * Get the dpdTimeoutSeconds property: Dead Peer Detection timeout in seconds for VpnLink connection.
     * 
     * @return the dpdTimeoutSeconds value.
     */
    public Integer dpdTimeoutSeconds() {
        return this.dpdTimeoutSeconds;
    }

    /**
     * Set the dpdTimeoutSeconds property: Dead Peer Detection timeout in seconds for VpnLink connection.
     * 
     * @param dpdTimeoutSeconds the dpdTimeoutSeconds value to set.
     * @return the VpnSiteLinkConnectionProperties object itself.
     */
    public VpnSiteLinkConnectionProperties withDpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
        this.dpdTimeoutSeconds = dpdTimeoutSeconds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vpnGatewayCustomBgpAddresses() != null) {
            vpnGatewayCustomBgpAddresses().forEach(e -> e.validate());
        }
        if (ipsecPolicies() != null) {
            ipsecPolicies().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("vpnSiteLink", this.vpnSiteLink);
        jsonWriter.writeNumberField("routingWeight", this.routingWeight);
        jsonWriter.writeStringField("vpnLinkConnectionMode",
            this.vpnLinkConnectionMode == null ? null : this.vpnLinkConnectionMode.toString());
        jsonWriter.writeStringField("vpnConnectionProtocolType",
            this.vpnConnectionProtocolType == null ? null : this.vpnConnectionProtocolType.toString());
        jsonWriter.writeNumberField("connectionBandwidth", this.connectionBandwidth);
        jsonWriter.writeStringField("sharedKey", this.sharedKey);
        jsonWriter.writeBooleanField("enableBgp", this.enableBgp);
        jsonWriter.writeArrayField("vpnGatewayCustomBgpAddresses", this.vpnGatewayCustomBgpAddresses,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("usePolicyBasedTrafficSelectors", this.usePolicyBasedTrafficSelectors);
        jsonWriter.writeArrayField("ipsecPolicies", this.ipsecPolicies, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("enableRateLimiting", this.enableRateLimiting);
        jsonWriter.writeBooleanField("useLocalAzureIpAddress", this.useLocalAzureIpAddress);
        jsonWriter.writeArrayField("ingressNatRules", this.ingressNatRules,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("egressNatRules", this.egressNatRules,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("dpdTimeoutSeconds", this.dpdTimeoutSeconds);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnSiteLinkConnectionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnSiteLinkConnectionProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnSiteLinkConnectionProperties.
     */
    public static VpnSiteLinkConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnSiteLinkConnectionProperties deserializedVpnSiteLinkConnectionProperties
                = new VpnSiteLinkConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vpnSiteLink".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.vpnSiteLink = SubResource.fromJson(reader);
                } else if ("routingWeight".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.routingWeight = reader.getNullable(JsonReader::getInt);
                } else if ("vpnLinkConnectionMode".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.vpnLinkConnectionMode
                        = VpnLinkConnectionMode.fromString(reader.getString());
                } else if ("connectionStatus".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.connectionStatus
                        = VpnConnectionStatus.fromString(reader.getString());
                } else if ("vpnConnectionProtocolType".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.vpnConnectionProtocolType
                        = VirtualNetworkGatewayConnectionProtocol.fromString(reader.getString());
                } else if ("ingressBytesTransferred".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.ingressBytesTransferred
                        = reader.getNullable(JsonReader::getLong);
                } else if ("egressBytesTransferred".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.egressBytesTransferred
                        = reader.getNullable(JsonReader::getLong);
                } else if ("connectionBandwidth".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.connectionBandwidth
                        = reader.getNullable(JsonReader::getInt);
                } else if ("sharedKey".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.sharedKey = reader.getString();
                } else if ("enableBgp".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.enableBgp = reader.getNullable(JsonReader::getBoolean);
                } else if ("vpnGatewayCustomBgpAddresses".equals(fieldName)) {
                    List<GatewayCustomBgpIpAddressIpConfiguration> vpnGatewayCustomBgpAddresses
                        = reader.readArray(reader1 -> GatewayCustomBgpIpAddressIpConfiguration.fromJson(reader1));
                    deserializedVpnSiteLinkConnectionProperties.vpnGatewayCustomBgpAddresses
                        = vpnGatewayCustomBgpAddresses;
                } else if ("usePolicyBasedTrafficSelectors".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.usePolicyBasedTrafficSelectors
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("ipsecPolicies".equals(fieldName)) {
                    List<IpsecPolicy> ipsecPolicies = reader.readArray(reader1 -> IpsecPolicy.fromJson(reader1));
                    deserializedVpnSiteLinkConnectionProperties.ipsecPolicies = ipsecPolicies;
                } else if ("enableRateLimiting".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.enableRateLimiting
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("useLocalAzureIpAddress".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.useLocalAzureIpAddress
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("ingressNatRules".equals(fieldName)) {
                    List<SubResource> ingressNatRules = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedVpnSiteLinkConnectionProperties.ingressNatRules = ingressNatRules;
                } else if ("egressNatRules".equals(fieldName)) {
                    List<SubResource> egressNatRules = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedVpnSiteLinkConnectionProperties.egressNatRules = egressNatRules;
                } else if ("dpdTimeoutSeconds".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionProperties.dpdTimeoutSeconds
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnSiteLinkConnectionProperties;
        });
    }
}
