// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.OfficeTrafficCategory;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Parameters for VirtualWAN.
 */
@Fluent
public final class VirtualWanProperties implements JsonSerializable<VirtualWanProperties> {
    /*
     * Vpn encryption to be disabled or not.
     */
    private Boolean disableVpnEncryption;

    /*
     * List of VirtualHubs in the VirtualWAN.
     */
    private List<SubResource> virtualHubs;

    /*
     * List of VpnSites in the VirtualWAN.
     */
    private List<SubResource> vpnSites;

    /*
     * True if branch to branch traffic is allowed.
     */
    private Boolean allowBranchToBranchTraffic;

    /*
     * True if Vnet to Vnet traffic is allowed.
     */
    private Boolean allowVnetToVnetTraffic;

    /*
     * The office local breakout category.
     */
    private OfficeTrafficCategory office365LocalBreakoutCategory;

    /*
     * The provisioning state of the virtual WAN resource.
     */
    private ProvisioningState provisioningState;

    /*
     * The type of the VirtualWAN.
     */
    private String type;

    /**
     * Creates an instance of VirtualWanProperties class.
     */
    public VirtualWanProperties() {
    }

    /**
     * Get the disableVpnEncryption property: Vpn encryption to be disabled or not.
     * 
     * @return the disableVpnEncryption value.
     */
    public Boolean disableVpnEncryption() {
        return this.disableVpnEncryption;
    }

    /**
     * Set the disableVpnEncryption property: Vpn encryption to be disabled or not.
     * 
     * @param disableVpnEncryption the disableVpnEncryption value to set.
     * @return the VirtualWanProperties object itself.
     */
    public VirtualWanProperties withDisableVpnEncryption(Boolean disableVpnEncryption) {
        this.disableVpnEncryption = disableVpnEncryption;
        return this;
    }

    /**
     * Get the virtualHubs property: List of VirtualHubs in the VirtualWAN.
     * 
     * @return the virtualHubs value.
     */
    public List<SubResource> virtualHubs() {
        return this.virtualHubs;
    }

    /**
     * Get the vpnSites property: List of VpnSites in the VirtualWAN.
     * 
     * @return the vpnSites value.
     */
    public List<SubResource> vpnSites() {
        return this.vpnSites;
    }

    /**
     * Get the allowBranchToBranchTraffic property: True if branch to branch traffic is allowed.
     * 
     * @return the allowBranchToBranchTraffic value.
     */
    public Boolean allowBranchToBranchTraffic() {
        return this.allowBranchToBranchTraffic;
    }

    /**
     * Set the allowBranchToBranchTraffic property: True if branch to branch traffic is allowed.
     * 
     * @param allowBranchToBranchTraffic the allowBranchToBranchTraffic value to set.
     * @return the VirtualWanProperties object itself.
     */
    public VirtualWanProperties withAllowBranchToBranchTraffic(Boolean allowBranchToBranchTraffic) {
        this.allowBranchToBranchTraffic = allowBranchToBranchTraffic;
        return this;
    }

    /**
     * Get the allowVnetToVnetTraffic property: True if Vnet to Vnet traffic is allowed.
     * 
     * @return the allowVnetToVnetTraffic value.
     */
    public Boolean allowVnetToVnetTraffic() {
        return this.allowVnetToVnetTraffic;
    }

    /**
     * Set the allowVnetToVnetTraffic property: True if Vnet to Vnet traffic is allowed.
     * 
     * @param allowVnetToVnetTraffic the allowVnetToVnetTraffic value to set.
     * @return the VirtualWanProperties object itself.
     */
    public VirtualWanProperties withAllowVnetToVnetTraffic(Boolean allowVnetToVnetTraffic) {
        this.allowVnetToVnetTraffic = allowVnetToVnetTraffic;
        return this;
    }

    /**
     * Get the office365LocalBreakoutCategory property: The office local breakout category.
     * 
     * @return the office365LocalBreakoutCategory value.
     */
    public OfficeTrafficCategory office365LocalBreakoutCategory() {
        return this.office365LocalBreakoutCategory;
    }

    /**
     * Get the provisioningState property: The provisioning state of the virtual WAN resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the type property: The type of the VirtualWAN.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the VirtualWAN.
     * 
     * @param type the type value to set.
     * @return the VirtualWanProperties object itself.
     */
    public VirtualWanProperties withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("disableVpnEncryption", this.disableVpnEncryption);
        jsonWriter.writeBooleanField("allowBranchToBranchTraffic", this.allowBranchToBranchTraffic);
        jsonWriter.writeBooleanField("allowVnetToVnetTraffic", this.allowVnetToVnetTraffic);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualWanProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualWanProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualWanProperties.
     */
    public static VirtualWanProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualWanProperties deserializedVirtualWanProperties = new VirtualWanProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("disableVpnEncryption".equals(fieldName)) {
                    deserializedVirtualWanProperties.disableVpnEncryption = reader.getNullable(JsonReader::getBoolean);
                } else if ("virtualHubs".equals(fieldName)) {
                    List<SubResource> virtualHubs = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedVirtualWanProperties.virtualHubs = virtualHubs;
                } else if ("vpnSites".equals(fieldName)) {
                    List<SubResource> vpnSites = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedVirtualWanProperties.vpnSites = vpnSites;
                } else if ("allowBranchToBranchTraffic".equals(fieldName)) {
                    deserializedVirtualWanProperties.allowBranchToBranchTraffic
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowVnetToVnetTraffic".equals(fieldName)) {
                    deserializedVirtualWanProperties.allowVnetToVnetTraffic
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("office365LocalBreakoutCategory".equals(fieldName)) {
                    deserializedVirtualWanProperties.office365LocalBreakoutCategory
                        = OfficeTrafficCategory.fromString(reader.getString());
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualWanProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("type".equals(fieldName)) {
                    deserializedVirtualWanProperties.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualWanProperties;
        });
    }
}
