// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayRequestRoutingRuleType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Properties of routing rule of the application gateway.
 */
@Fluent
public final class ApplicationGatewayRoutingRulePropertiesFormat
    implements JsonSerializable<ApplicationGatewayRoutingRulePropertiesFormat> {
    /*
     * Rule type.
     */
    private ApplicationGatewayRequestRoutingRuleType ruleType;

    /*
     * Priority of the routing rule.
     */
    private int priority;

    /*
     * Backend address pool resource of the application gateway.
     */
    private SubResource backendAddressPool;

    /*
     * Backend settings resource of the application gateway.
     */
    private SubResource backendSettings;

    /*
     * Listener resource of the application gateway.
     */
    private SubResource listener;

    /*
     * The provisioning state of the request routing rule resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ApplicationGatewayRoutingRulePropertiesFormat class.
     */
    public ApplicationGatewayRoutingRulePropertiesFormat() {
    }

    /**
     * Get the ruleType property: Rule type.
     * 
     * @return the ruleType value.
     */
    public ApplicationGatewayRequestRoutingRuleType ruleType() {
        return this.ruleType;
    }

    /**
     * Set the ruleType property: Rule type.
     * 
     * @param ruleType the ruleType value to set.
     * @return the ApplicationGatewayRoutingRulePropertiesFormat object itself.
     */
    public ApplicationGatewayRoutingRulePropertiesFormat
        withRuleType(ApplicationGatewayRequestRoutingRuleType ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    /**
     * Get the priority property: Priority of the routing rule.
     * 
     * @return the priority value.
     */
    public int priority() {
        return this.priority;
    }

    /**
     * Set the priority property: Priority of the routing rule.
     * 
     * @param priority the priority value to set.
     * @return the ApplicationGatewayRoutingRulePropertiesFormat object itself.
     */
    public ApplicationGatewayRoutingRulePropertiesFormat withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the backendAddressPool property: Backend address pool resource of the application gateway.
     * 
     * @return the backendAddressPool value.
     */
    public SubResource backendAddressPool() {
        return this.backendAddressPool;
    }

    /**
     * Set the backendAddressPool property: Backend address pool resource of the application gateway.
     * 
     * @param backendAddressPool the backendAddressPool value to set.
     * @return the ApplicationGatewayRoutingRulePropertiesFormat object itself.
     */
    public ApplicationGatewayRoutingRulePropertiesFormat withBackendAddressPool(SubResource backendAddressPool) {
        this.backendAddressPool = backendAddressPool;
        return this;
    }

    /**
     * Get the backendSettings property: Backend settings resource of the application gateway.
     * 
     * @return the backendSettings value.
     */
    public SubResource backendSettings() {
        return this.backendSettings;
    }

    /**
     * Set the backendSettings property: Backend settings resource of the application gateway.
     * 
     * @param backendSettings the backendSettings value to set.
     * @return the ApplicationGatewayRoutingRulePropertiesFormat object itself.
     */
    public ApplicationGatewayRoutingRulePropertiesFormat withBackendSettings(SubResource backendSettings) {
        this.backendSettings = backendSettings;
        return this;
    }

    /**
     * Get the listener property: Listener resource of the application gateway.
     * 
     * @return the listener value.
     */
    public SubResource listener() {
        return this.listener;
    }

    /**
     * Set the listener property: Listener resource of the application gateway.
     * 
     * @param listener the listener value to set.
     * @return the ApplicationGatewayRoutingRulePropertiesFormat object itself.
     */
    public ApplicationGatewayRoutingRulePropertiesFormat withListener(SubResource listener) {
        this.listener = listener;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the request routing rule resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("priority", this.priority);
        jsonWriter.writeStringField("ruleType", this.ruleType == null ? null : this.ruleType.toString());
        jsonWriter.writeJsonField("backendAddressPool", this.backendAddressPool);
        jsonWriter.writeJsonField("backendSettings", this.backendSettings);
        jsonWriter.writeJsonField("listener", this.listener);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayRoutingRulePropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayRoutingRulePropertiesFormat if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApplicationGatewayRoutingRulePropertiesFormat.
     */
    public static ApplicationGatewayRoutingRulePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayRoutingRulePropertiesFormat deserializedApplicationGatewayRoutingRulePropertiesFormat
                = new ApplicationGatewayRoutingRulePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("priority".equals(fieldName)) {
                    deserializedApplicationGatewayRoutingRulePropertiesFormat.priority = reader.getInt();
                } else if ("ruleType".equals(fieldName)) {
                    deserializedApplicationGatewayRoutingRulePropertiesFormat.ruleType
                        = ApplicationGatewayRequestRoutingRuleType.fromString(reader.getString());
                } else if ("backendAddressPool".equals(fieldName)) {
                    deserializedApplicationGatewayRoutingRulePropertiesFormat.backendAddressPool
                        = SubResource.fromJson(reader);
                } else if ("backendSettings".equals(fieldName)) {
                    deserializedApplicationGatewayRoutingRulePropertiesFormat.backendSettings
                        = SubResource.fromJson(reader);
                } else if ("listener".equals(fieldName)) {
                    deserializedApplicationGatewayRoutingRulePropertiesFormat.listener = SubResource.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayRoutingRulePropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayRoutingRulePropertiesFormat;
        });
    }
}
