/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ManagedRuleSet;
import com.azure.resourcemanager.network.models.OwaspCrsExclusionEntry;
import java.io.IOException;
import java.util.List;

public final class ManagedRulesDefinition
implements JsonSerializable<ManagedRulesDefinition> {
    private List<OwaspCrsExclusionEntry> exclusions;
    private List<ManagedRuleSet> managedRuleSets;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedRulesDefinition.class);

    public List<OwaspCrsExclusionEntry> exclusions() {
        return this.exclusions;
    }

    public ManagedRulesDefinition withExclusions(List<OwaspCrsExclusionEntry> exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    public List<ManagedRuleSet> managedRuleSets() {
        return this.managedRuleSets;
    }

    public ManagedRulesDefinition withManagedRuleSets(List<ManagedRuleSet> managedRuleSets) {
        this.managedRuleSets = managedRuleSets;
        return this;
    }

    public void validate() {
        if (this.exclusions() != null) {
            this.exclusions().forEach(e -> e.validate());
        }
        if (this.managedRuleSets() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property managedRuleSets in model ManagedRulesDefinition"));
        }
        this.managedRuleSets().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("managedRuleSets", this.managedRuleSets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("exclusions", this.exclusions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedRulesDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedRulesDefinition)jsonReader.readObject(reader -> {
            ManagedRulesDefinition deserializedManagedRulesDefinition = new ManagedRulesDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("managedRuleSets".equals(fieldName)) {
                    List managedRuleSets;
                    deserializedManagedRulesDefinition.managedRuleSets = managedRuleSets = reader.readArray(reader1 -> ManagedRuleSet.fromJson(reader1));
                    continue;
                }
                if ("exclusions".equals(fieldName)) {
                    List exclusions;
                    deserializedManagedRulesDefinition.exclusions = exclusions = reader.readArray(reader1 -> OwaspCrsExclusionEntry.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedRulesDefinition;
        });
    }
}

