/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayWafRuleActionTypes;
import com.azure.resourcemanager.network.models.ApplicationGatewayWafRuleStateTypes;
import java.io.IOException;

public final class ApplicationGatewayFirewallRule
implements JsonSerializable<ApplicationGatewayFirewallRule> {
    private int ruleId;
    private String ruleIdString;
    private ApplicationGatewayWafRuleStateTypes state;
    private ApplicationGatewayWafRuleActionTypes action;
    private String description;

    public int ruleId() {
        return this.ruleId;
    }

    public ApplicationGatewayFirewallRule withRuleId(int ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    public String ruleIdString() {
        return this.ruleIdString;
    }

    public ApplicationGatewayFirewallRule withRuleIdString(String ruleIdString) {
        this.ruleIdString = ruleIdString;
        return this;
    }

    public ApplicationGatewayWafRuleStateTypes state() {
        return this.state;
    }

    public ApplicationGatewayFirewallRule withState(ApplicationGatewayWafRuleStateTypes state) {
        this.state = state;
        return this;
    }

    public ApplicationGatewayWafRuleActionTypes action() {
        return this.action;
    }

    public ApplicationGatewayFirewallRule withAction(ApplicationGatewayWafRuleActionTypes action) {
        this.action = action;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ApplicationGatewayFirewallRule withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("ruleId", this.ruleId);
        jsonWriter.writeStringField("ruleIdString", this.ruleIdString);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayFirewallRule fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayFirewallRule)jsonReader.readObject(reader -> {
            ApplicationGatewayFirewallRule deserializedApplicationGatewayFirewallRule = new ApplicationGatewayFirewallRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleId".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRule.ruleId = reader.getInt();
                    continue;
                }
                if ("ruleIdString".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRule.ruleIdString = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRule.state = ApplicationGatewayWafRuleStateTypes.fromString(reader.getString());
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRule.action = ApplicationGatewayWafRuleActionTypes.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRule.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayFirewallRule;
        });
    }
}

