/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ServiceEndpointPolicyDefinitionInner;
import com.azure.resourcemanager.network.fluent.models.ServiceEndpointPolicyPropertiesFormat;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ServiceEndpointPolicyInner
extends Resource {
    private ServiceEndpointPolicyPropertiesFormat innerProperties;
    private String etag;
    private String kind;
    private String id;
    private String name;
    private String type;

    private ServiceEndpointPolicyPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String kind() {
        return this.kind;
    }

    public String id() {
        return this.id;
    }

    public ServiceEndpointPolicyInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public ServiceEndpointPolicyInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ServiceEndpointPolicyInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<ServiceEndpointPolicyDefinitionInner> serviceEndpointPolicyDefinitions() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceEndpointPolicyDefinitions();
    }

    public ServiceEndpointPolicyInner withServiceEndpointPolicyDefinitions(List<ServiceEndpointPolicyDefinitionInner> serviceEndpointPolicyDefinitions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServiceEndpointPolicyPropertiesFormat();
        }
        this.innerProperties().withServiceEndpointPolicyDefinitions(serviceEndpointPolicyDefinitions);
        return this;
    }

    public List<SubnetInner> subnets() {
        return this.innerProperties() == null ? null : this.innerProperties().subnets();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String serviceAlias() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceAlias();
    }

    public ServiceEndpointPolicyInner withServiceAlias(String serviceAlias) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServiceEndpointPolicyPropertiesFormat();
        }
        this.innerProperties().withServiceAlias(serviceAlias);
        return this;
    }

    public List<String> contextualServiceEndpointPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().contextualServiceEndpointPolicies();
    }

    public ServiceEndpointPolicyInner withContextualServiceEndpointPolicies(List<String> contextualServiceEndpointPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServiceEndpointPolicyPropertiesFormat();
        }
        this.innerProperties().withContextualServiceEndpointPolicies(contextualServiceEndpointPolicies);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static ServiceEndpointPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceEndpointPolicyInner)((Object)jsonReader.readObject(reader -> {
            ServiceEndpointPolicyInner deserializedServiceEndpointPolicyInner = new ServiceEndpointPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedServiceEndpointPolicyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedServiceEndpointPolicyInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedServiceEndpointPolicyInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedServiceEndpointPolicyInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedServiceEndpointPolicyInner.innerProperties = ServiceEndpointPolicyPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedServiceEndpointPolicyInner.etag = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedServiceEndpointPolicyInner.kind = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedServiceEndpointPolicyInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceEndpointPolicyInner;
        }));
    }
}

