/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkManagerProperties;
import com.azure.resourcemanager.network.models.ConfigurationType;
import com.azure.resourcemanager.network.models.NetworkManagerPropertiesNetworkManagerScopes;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class NetworkManagerInner
extends Resource {
    private NetworkManagerProperties innerProperties;
    private String etag;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private NetworkManagerProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public NetworkManagerInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public NetworkManagerInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public NetworkManagerInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public NetworkManagerInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkManagerProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public NetworkManagerPropertiesNetworkManagerScopes networkManagerScopes() {
        return this.innerProperties() == null ? null : this.innerProperties().networkManagerScopes();
    }

    public NetworkManagerInner withNetworkManagerScopes(NetworkManagerPropertiesNetworkManagerScopes networkManagerScopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkManagerProperties();
        }
        this.innerProperties().withNetworkManagerScopes(networkManagerScopes);
        return this;
    }

    public List<ConfigurationType> networkManagerScopeAccesses() {
        return this.innerProperties() == null ? null : this.innerProperties().networkManagerScopeAccesses();
    }

    public NetworkManagerInner withNetworkManagerScopeAccesses(List<ConfigurationType> networkManagerScopeAccesses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkManagerProperties();
        }
        this.innerProperties().withNetworkManagerScopeAccesses(networkManagerScopeAccesses);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static NetworkManagerInner fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkManagerInner)((Object)jsonReader.readObject(reader -> {
            NetworkManagerInner deserializedNetworkManagerInner = new NetworkManagerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNetworkManagerInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetworkManagerInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedNetworkManagerInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedNetworkManagerInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkManagerInner.innerProperties = NetworkManagerProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedNetworkManagerInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedNetworkManagerInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedNetworkManagerInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkManagerInner;
        }));
    }
}

