/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfacePropertiesFormatInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceTapConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.PrivateEndpointInner;
import com.azure.resourcemanager.network.fluent.models.PrivateLinkServiceInner;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.NetworkInterfaceAuxiliaryMode;
import com.azure.resourcemanager.network.models.NetworkInterfaceAuxiliarySku;
import com.azure.resourcemanager.network.models.NetworkInterfaceDnsSettings;
import com.azure.resourcemanager.network.models.NetworkInterfaceMigrationPhase;
import com.azure.resourcemanager.network.models.NetworkInterfaceNicType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class NetworkInterfaceInner
extends Resource {
    private ExtendedLocation extendedLocation;
    private NetworkInterfacePropertiesFormatInner innerProperties;
    private String etag;
    private String id;
    private String name;
    private String type;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public NetworkInterfaceInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private NetworkInterfacePropertiesFormatInner innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public NetworkInterfaceInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public NetworkInterfaceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public NetworkInterfaceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubResource virtualMachine() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachine();
    }

    public NetworkSecurityGroupInner networkSecurityGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().networkSecurityGroup();
    }

    public NetworkInterfaceInner withNetworkSecurityGroup(NetworkSecurityGroupInner networkSecurityGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkInterfacePropertiesFormatInner();
        }
        this.innerProperties().withNetworkSecurityGroup(networkSecurityGroup);
        return this;
    }

    public PrivateEndpointInner privateEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpoint();
    }

    public List<NetworkInterfaceIpConfigurationInner> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public NetworkInterfaceInner withIpConfigurations(List<NetworkInterfaceIpConfigurationInner> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkInterfacePropertiesFormatInner();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    public List<NetworkInterfaceTapConfigurationInner> tapConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().tapConfigurations();
    }

    public NetworkInterfaceDnsSettings dnsSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsSettings();
    }

    public NetworkInterfaceInner withDnsSettings(NetworkInterfaceDnsSettings dnsSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkInterfacePropertiesFormatInner();
        }
        this.innerProperties().withDnsSettings(dnsSettings);
        return this;
    }

    public String macAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().macAddress();
    }

    public Boolean primary() {
        return this.innerProperties() == null ? null : this.innerProperties().primary();
    }

    public Boolean vnetEncryptionSupported() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetEncryptionSupported();
    }

    public Boolean enableAcceleratedNetworking() {
        return this.innerProperties() == null ? null : this.innerProperties().enableAcceleratedNetworking();
    }

    public NetworkInterfaceInner withEnableAcceleratedNetworking(Boolean enableAcceleratedNetworking) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkInterfacePropertiesFormatInner();
        }
        this.innerProperties().withEnableAcceleratedNetworking(enableAcceleratedNetworking);
        return this;
    }

    public Boolean disableTcpStateTracking() {
        return this.innerProperties() == null ? null : this.innerProperties().disableTcpStateTracking();
    }

    public NetworkInterfaceInner withDisableTcpStateTracking(Boolean disableTcpStateTracking) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkInterfacePropertiesFormatInner();
        }
        this.innerProperties().withDisableTcpStateTracking(disableTcpStateTracking);
        return this;
    }

    public Boolean enableIpForwarding() {
        return this.innerProperties() == null ? null : this.innerProperties().enableIpForwarding();
    }

    public NetworkInterfaceInner withEnableIpForwarding(Boolean enableIpForwarding) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkInterfacePropertiesFormatInner();
        }
        this.innerProperties().withEnableIpForwarding(enableIpForwarding);
        return this;
    }

    public List<String> hostedWorkloads() {
        return this.innerProperties() == null ? null : this.innerProperties().hostedWorkloads();
    }

    public SubResource dscpConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().dscpConfiguration();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String workloadType() {
        return this.innerProperties() == null ? null : this.innerProperties().workloadType();
    }

    public NetworkInterfaceInner withWorkloadType(String workloadType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkInterfacePropertiesFormatInner();
        }
        this.innerProperties().withWorkloadType(workloadType);
        return this;
    }

    public NetworkInterfaceNicType nicType() {
        return this.innerProperties() == null ? null : this.innerProperties().nicType();
    }

    public NetworkInterfaceInner withNicType(NetworkInterfaceNicType nicType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkInterfacePropertiesFormatInner();
        }
        this.innerProperties().withNicType(nicType);
        return this;
    }

    public PrivateLinkServiceInner privateLinkService() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkService();
    }

    public NetworkInterfaceInner withPrivateLinkService(PrivateLinkServiceInner privateLinkService) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkInterfacePropertiesFormatInner();
        }
        this.innerProperties().withPrivateLinkService(privateLinkService);
        return this;
    }

    public NetworkInterfaceMigrationPhase migrationPhase() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationPhase();
    }

    public NetworkInterfaceInner withMigrationPhase(NetworkInterfaceMigrationPhase migrationPhase) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkInterfacePropertiesFormatInner();
        }
        this.innerProperties().withMigrationPhase(migrationPhase);
        return this;
    }

    public NetworkInterfaceAuxiliaryMode auxiliaryMode() {
        return this.innerProperties() == null ? null : this.innerProperties().auxiliaryMode();
    }

    public NetworkInterfaceInner withAuxiliaryMode(NetworkInterfaceAuxiliaryMode auxiliaryMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkInterfacePropertiesFormatInner();
        }
        this.innerProperties().withAuxiliaryMode(auxiliaryMode);
        return this;
    }

    public NetworkInterfaceAuxiliarySku auxiliarySku() {
        return this.innerProperties() == null ? null : this.innerProperties().auxiliarySku();
    }

    public NetworkInterfaceInner withAuxiliarySku(NetworkInterfaceAuxiliarySku auxiliarySku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkInterfacePropertiesFormatInner();
        }
        this.innerProperties().withAuxiliarySku(auxiliarySku);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static NetworkInterfaceInner fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkInterfaceInner)((Object)jsonReader.readObject(reader -> {
            NetworkInterfaceInner deserializedNetworkInterfaceInner = new NetworkInterfaceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNetworkInterfaceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetworkInterfaceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedNetworkInterfaceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedNetworkInterfaceInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedNetworkInterfaceInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkInterfaceInner.innerProperties = NetworkInterfacePropertiesFormatInner.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedNetworkInterfaceInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedNetworkInterfaceInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkInterfaceInner;
        }));
    }
}

